/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.BlockStatement;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeType;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.KeywordStatement;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Parameter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.TryStatement;
import net.jangaroo.jooc.Type;
import net.jangaroo.jooc.TypeRelation;

class Catch
extends KeywordStatement {
    private JooSymbol lParen;
    private Parameter param;
    private JooSymbol rParen;
    private BlockStatement block;

    public Catch(JooSymbol symCatch, JooSymbol lParen, Parameter param, JooSymbol rParen, BlockStatement block) {
        super(symCatch);
        this.lParen = lParen;
        this.param = param;
        this.rParen = rParen;
        this.block = block;
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        List<Catch> catches = ((TryStatement)this.parentNode).catches;
        Catch firstCatch = catches.get(0);
        boolean isFirst = this.equals(firstCatch);
        boolean isLast = this.equals(catches.get(catches.size() - 1));
        TypeRelation typeRelation = this.param.optTypeRelation;
        boolean hasCondition = this.hasCondition();
        if (!hasCondition && !isLast) {
            throw Jooc.error(this.rParen, "Only last catch clause may be untyped.");
        }
        JooSymbol errorVar = firstCatch.param.getIde().ide;
        JooSymbol localErrorVar = this.param.getIde().ide;
        out.writeSymbolWhitespace(this.symKeyword);
        if (isFirst) {
            out.writeSymbolToken(this.symKeyword);
            out.writeSymbol(this.lParen, !hasCondition);
            out.writeSymbol(errorVar, !hasCondition);
            if (!hasCondition && typeRelation != null) {
                typeRelation.generateCode(out);
            }
            out.writeSymbol(this.rParen, !hasCondition);
            if (hasCondition || !isLast) {
                out.writeToken("{");
            }
        } else {
            out.writeToken("else");
        }
        if (hasCondition) {
            out.writeToken("if(is");
            out.writeSymbol(this.lParen);
            out.writeSymbolWhitespace(localErrorVar);
            out.writeSymbolToken(errorVar);
            out.writeSymbolWhitespace(typeRelation.symRelation);
            out.writeToken(",");
            Ide typeIde = ((IdeType)typeRelation.getType()).getIde();
            out.writeSymbolWhitespace(typeIde.getIde());
            out.writeToken(typeIde.getDeclaration().getQualifiedNameStr());
            out.writeSymbol(this.rParen);
            out.writeToken(")");
        }
        if (!localErrorVar.getText().equals(errorVar.getText())) {
            this.block.addBlockStartCodeGenerator(new VarCodeGenerator(localErrorVar, errorVar));
        }
        this.block.generateCode(out);
        if (isLast) {
            if (hasCondition) {
                out.writeToken("else throw");
                out.writeSymbolToken(errorVar);
                out.writeToken(";");
            }
            if (!isFirst || hasCondition) {
                out.writeToken("}");
            }
        }
    }

    private boolean hasCondition() {
        TypeRelation typeRelation = this.param.optTypeRelation;
        return typeRelation != null && typeRelation.getType().getSymbol().sym != 51;
    }

    public void scope(Scope scope) {
        if (this.hasCondition()) {
            scope.getClassDeclaration().addBuiltInUsage("is");
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                Catch.this.param.scope(scope);
                Catch.this.block.scope(scope);
            }
        });
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        Type type;
        super.analyze(parentNode, context);
        this.param.analyze(this, context);
        TypeRelation typeRelation = this.param.optTypeRelation;
        if (typeRelation != null && (type = typeRelation.getType()) instanceof IdeType) {
            IdeType ideType = (IdeType)type;
            ideType.getIde().addExternalUsage();
        }
        this.block.analyze(this, context);
        return this;
    }

    private static class VarCodeGenerator
    implements CodeGenerator {
        private final JooSymbol localErrorVar;
        private final JooSymbol errorVar;

        public VarCodeGenerator(JooSymbol localErrorVar, JooSymbol errorVar) {
            this.localErrorVar = localErrorVar;
            this.errorVar = errorVar;
        }

        public void generateCode(JsWriter out) throws IOException {
            out.writeToken("var");
            out.writeSymbolToken(this.localErrorVar);
            out.writeToken("=");
            out.writeSymbolToken(this.errorVar);
            out.writeToken(";");
        }
    }
}

