/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.ConditionalLoopStatement;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.ForInitializer;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;

class ForStatement
extends ConditionalLoopStatement {
    private JooSymbol lParen;
    private ForInitializer forInit;
    private JooSymbol symSemicolon1;
    private Expr optCond;
    private JooSymbol symSemicolon2;
    private Expr optStep;
    private JooSymbol rParen;

    public ForStatement(JooSymbol symFor, JooSymbol lParen, ForInitializer forInit, JooSymbol symSemicolon1, Expr optCond, JooSymbol symSemicolon2, Expr optStep, JooSymbol rParen, Statement body) {
        super(symFor, optCond, body);
        this.lParen = lParen;
        this.forInit = forInit;
        this.symSemicolon1 = symSemicolon1;
        this.symSemicolon2 = symSemicolon2;
        this.optStep = optStep;
        this.rParen = rParen;
    }

    protected void generateLoopHeaderCode(JsWriter out) throws IOException {
        out.writeSymbol(this.lParen);
        if (this.forInit != null) {
            this.forInit.generateCode(out);
        }
        out.writeSymbol(this.symSemicolon1);
        super.generateLoopHeaderCode(out);
        out.writeSymbol(this.symSemicolon2);
        if (this.optStep != null) {
            this.optStep.generateCode(out);
        }
        out.writeSymbol(this.rParen);
    }

    public void scope(Scope scope) {
        if (this.forInit != null) {
            this.forInit.scope(scope);
        }
        super.scope(scope);
        if (this.optStep != null) {
            this.optStep.scope(scope);
        }
    }

    protected void analyzeLoopHeader(AnalyzeContext context) {
        this.checkNonVirtualSemicolon(this.symSemicolon1);
        this.checkNonVirtualSemicolon(this.symSemicolon2);
        if (this.forInit != null) {
            this.forInit.analyze(this, context);
        }
        super.analyzeLoopHeader(context);
        if (this.optStep != null) {
            this.optStep.analyze(this, context);
        }
    }

    private void checkNonVirtualSemicolon(JooSymbol semi) {
        if (semi.isVirtual()) {
            throw Jooc.error(semi, "missing ';'(automatic semicolon insertion would become one of the two semicolons in the header of a for statement)");
        }
    }
}

