/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.BlockStatement;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.FunctionDeclaration;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Parameter;
import net.jangaroo.jooc.Parameters;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.TypeRelation;
import net.jangaroo.jooc.VariableDeclaration;

class FunctionExpr
extends Expr {
    public static final Ide ARGUMENTS_IDE = new Ide(new JooSymbol("arguments"));
    private JooSymbol symFun;
    private Ide ide;
    private JooSymbol lParen;
    private Parameters params;
    private JooSymbol rParen;
    private TypeRelation optTypeRelation;
    private BlockStatement body;
    private IdeDeclaration parentDeclaration;
    private boolean thisUsed;

    public FunctionExpr(JooSymbol symFun, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, BlockStatement body) {
        this.symFun = symFun;
        this.ide = ide;
        this.lParen = lParen;
        this.params = params;
        this.rParen = rParen;
        this.optTypeRelation = optTypeRelation;
        this.body = body;
    }

    public IdeDeclaration getParentDeclaration() {
        return this.parentDeclaration;
    }

    public void scope(Scope scope) {
        AstNode declaration;
        this.parentDeclaration = scope.getClassDeclaration();
        if (this.parentDeclaration == null && (declaration = scope.getDefiningNode()) instanceof IdeDeclaration) {
            this.parentDeclaration = (IdeDeclaration)declaration;
        }
        if (this.ide != null) {
            VariableDeclaration decl = new VariableDeclaration(null, this.ide, null, null);
            ((IdeDeclaration)decl).scope(scope);
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                new Parameter(null, ARGUMENTS_IDE, null, null).scope(scope);
                FunctionExpr.this.withNewDeclarationScope(FunctionExpr.this, scope, new NodeImplBase.Scoped(){

                    public void run(Scope scope) {
                        if (FunctionExpr.this.params != null) {
                            FunctionExpr.this.params.scope(scope);
                        }
                        if (FunctionExpr.this.optTypeRelation != null) {
                            FunctionExpr.this.optTypeRelation.scope(scope);
                        }
                        FunctionExpr.this.body.scope(scope);
                    }
                });
            }
        });
    }

    public Expr analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.params != null) {
            this.params.analyze(this, context);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(this, context);
        }
        this.body.analyze(this, context);
        return this;
    }

    public boolean notifyThisUsed(Scope scope) {
        FunctionDeclaration methodDeclaration;
        if (!this.thisUsed && (methodDeclaration = scope.getMethodDeclaration()) != null && !methodDeclaration.isStatic()) {
            this.thisUsed = true;
            ((BlockStatement)methodDeclaration.getBody()).addBlockStartCodeGenerator(new CodeGenerator(){

                public void generateCode(JsWriter out) throws IOException {
                    out.write("var this$=this;");
                }
            });
            return true;
        }
        return this.thisUsed;
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        out.writeSymbol(this.symFun);
        if (this.ide != null) {
            out.writeToken(this.ide.getName());
        } else if (out.getKeepSource()) {
            out.writeToken(out.getFunctionNameAsIde(this));
        }
        out.writeSymbol(this.lParen);
        if (this.params != null) {
            this.params.generateCode(out);
        }
        out.writeSymbol(this.rParen);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.generateCode(out);
        }
        this.body.generateCode(out);
    }

    public JooSymbol getSymbol() {
        return this.symFun;
    }

    boolean isCompileTimeConstant() {
        return true;
    }

    public /* synthetic */ AstNode analyze(AstNode x0, AnalyzeContext x1) {
        return this.analyze(x0, x1);
    }
}

