/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.CompileLog;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.config.CommandLineParseException;
import net.jangaroo.jooc.config.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.PathInputSource;

public class Jooc
extends JangarooParser {
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_COMPILATION_FAILED = 1;
    public static final int RESULT_CODE_INTERNAL_COMPILER_ERROR = 2;
    public static final int RESULT_CODE_UNRECOGNIZED_OPTION = 3;
    public static final int RESULT_CODE_MISSING_OPTION_ARGUMENT = 4;
    public static final int RESULT_CODE_ILLEGAL_OPTION_VALUE = 5;
    public static final String INPUT_FILE_SUFFIX = ".as";
    public static final String OUTPUT_FILE_SUFFIX = ".js";
    public static final String CLASS_LOADER_NAME = "classLoader";
    public static final String CLASS_LOADER_PACKAGE_NAME = "joo";
    public static final String CLASS_LOADER_FULLY_QUALIFIED_NAME = "joo.classLoader";
    private List<CompilationUnit> compileQueue = new ArrayList<CompilationUnit>();

    public Jooc(JoocConfiguration config) {
        this(config, (CompileLog)new StdOutCompileLog());
    }

    public Jooc(JoocConfiguration config, CompileLog log) {
        super(config, log);
    }

    @Override
    public JoocConfiguration getConfig() {
        return (JoocConfiguration)super.getConfig();
    }

    public int run() {
        try {
            return this.run1();
        }
        catch (CompilerError e) {
            if (e.getSymbol() != null) {
                this.log.error(e.getSymbol(), e.getMessage());
            } else {
                this.log.error(e.getMessage());
            }
            return 1;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return 2;
        }
    }

    private int run1() {
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        try {
            sourcePathInputSource = PathInputSource.fromFiles(this.getConfig().getSourcePath(), new String[]{""});
            classPathInputSource = PathInputSource.fromFiles(this.getConfig().getClassPath(), new String[]{"", "META-INF/joo-api/"});
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        this.setUp(sourcePathInputSource, classPathInputSource);
        try {
            for (File sourceFile : this.getConfig().getSourceFiles()) {
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(this.getConfig(), false);
            CompilationUnitSinkFactory apiSinkFactory = null;
            if (this.getConfig().isGenerateApi()) {
                apiSinkFactory = this.createSinkFactory(this.getConfig(), true);
            }
            for (CompilationUnit unit : this.compileQueue) {
                unit.analyze(null);
                this.writeOutput(unit, codeSinkFactory, this.getConfig().isVerbose());
                if (!this.getConfig().isGenerateApi()) continue;
                this.writeOutput(unit, apiSinkFactory, this.getConfig().isVerbose());
            }
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        int result = this.log.hasErrors() ? 1 : 0;
        this.tearDown();
        return result;
    }

    public void writeOutput(CompilationUnit compilationUnit, CompilationUnitSinkFactory writerFactory, boolean verbose) throws CompilerError {
        File sourceFile = ((FileInputSource)compilationUnit.getSource()).getFile();
        CompilationUnitSink sink = writerFactory.createSink(compilationUnit.getPackageDeclaration(), compilationUnit.getPrimaryDeclaration(), sourceFile, verbose);
        sink.writeOutput(compilationUnit);
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, boolean generateActionScriptApi) {
        AbstractCompilationUnitSinkFactory codeSinkFactory;
        if (!generateActionScriptApi && config.isMergeOutput()) {
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory(config, config.getOutputFile());
        } else {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String suffix = generateActionScriptApi ? INPUT_FILE_SUFFIX : OUTPUT_FILE_SUFFIX;
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory(config, outputDirectory, generateActionScriptApi, suffix);
        }
        return codeSinkFactory;
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
            case 5: {
                return "illegal option value";
            }
        }
        return "unknown result code";
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error("Input file is a directory: " + file.getAbsolutePath());
        }
        CompilationUnit unit = this.importSource(new FileInputSource(this.getConfig().findSourceDir(file), file));
        if (unit != null) {
            this.compileQueue.add(unit);
        }
    }

    protected static void printVersion() {
        String pkgName = "net.jangaroo.jooc";
        Package pkg = Package.getPackage(pkgName);
        String specTitle = pkg.getSpecificationTitle();
        if (specTitle == null) {
            System.out.println("cannot retrieve package version information for " + pkgName);
            return;
        }
        String specVendor = pkg.getSpecificationVendor();
        String specVersion = pkg.getSpecificationVersion();
        String implTitle = pkg.getImplementationTitle();
        String implVersion = pkg.getImplementationVersion();
        System.out.println(specTitle + " version " + specVersion);
        System.out.println(implTitle + " (build " + implVersion + ")");
        System.out.println(specVendor);
    }

    public static int run(String[] argv, CompileLog log) {
        block3: {
            try {
                JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
                JoocConfiguration config = commandLineParser.parse(argv);
                if (config == null) break block3;
                if (config.isVersion()) {
                    Jooc.printVersion();
                    break block3;
                }
                return new Jooc(config, log).run();
            }
            catch (CommandLineParseException e) {
                System.out.println(e.getMessage());
                return e.getExitCode();
            }
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Jooc.run(argv, new StdOutCompileLog());
        if (result != 0) {
            System.exit(result);
        }
    }
}

