/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;

public class FunctionDeclaration
extends TypedIdeDeclaration {
    private FunctionExpr fun;
    private JooSymbol symGetOrSet;
    private JooSymbol optSymSemicolon;
    private boolean isConstructor = false;
    private boolean containsSuperConstructorCall = false;
    private static final int DEFAULT_ALLOWED_METHOD_MODIFIERS = 3839;

    public FunctionDeclaration(List<JooSymbol> modifiers, JooSymbol symFunction, JooSymbol symGetOrSet, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, BlockStatement optBody, JooSymbol optSymSemicolon) {
        super(modifiers.toArray(new JooSymbol[modifiers.size()]), ide, null);
        this.fun = new FunctionExpr(this, symFunction, ide, lParen, params, rParen, optTypeRelation, optBody);
        this.symGetOrSet = symGetOrSet;
        this.optSymSemicolon = optSymSemicolon;
        if (this.isGetterOrSetter() && !this.isGetter() && !this.isSetter()) {
            throw Jooc.error(symGetOrSet, "Expected 'get' or 'set'.");
        }
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitFunctionDeclaration(this);
    }

    public boolean overrides() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isMethod() {
        return this.isClassMember();
    }

    public boolean isGetterOrSetter() {
        return this.symGetOrSet != null;
    }

    public boolean isGetter() {
        return this.isGetterOrSetter() && "get".equals(this.symGetOrSet.getText());
    }

    public boolean isSetter() {
        return this.isGetterOrSetter() && "set".equals(this.symGetOrSet.getText());
    }

    @Override
    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public FunctionExpr getFun() {
        return this.fun;
    }

    public JooSymbol getSymGetOrSet() {
        return this.symGetOrSet;
    }

    public JooSymbol getOptSymSemicolon() {
        return this.optSymSemicolon;
    }

    public boolean containsSuperConstructorCall() {
        return this.isContainsSuperConstructorCall();
    }

    public void setContainsSuperConstructorCall(boolean containsSuperConstructorCallStatement) {
        this.containsSuperConstructorCall = containsSuperConstructorCallStatement;
    }

    @Override
    public boolean isAbstract() {
        return this.getClassDeclaration() != null && this.getClassDeclaration().isInterface() || super.isAbstract();
    }

    public Parameters getParams() {
        return this.fun.getParams();
    }

    public boolean hasBody() {
        return this.fun.hasBody();
    }

    public BlockStatement getBody() {
        return this.fun.getBody();
    }

    @Override
    public void scope(Scope scope) {
        ClassDeclaration classDeclaration = scope.getClassDeclaration();
        Ide oldIde = this.getIde();
        if (classDeclaration != null && this.getIde().getName().equals(classDeclaration.getName())) {
            this.setConstructor(true);
            classDeclaration.setConstructor(this);
            this.setIde(null);
        }
        super.scope(scope);
        this.setIde(oldIde);
        if (this.overrides() && this.isAbstract()) {
            throw Jooc.error(this, "overriding methods are not allowed to be declared abstract");
        }
        if (this.isAbstract()) {
            if (classDeclaration == null) {
                throw Jooc.error(this, "package-scoped function " + this.getName() + " must not be abstract.");
            }
            if (!classDeclaration.isAbstract()) {
                throw Jooc.error(this, classDeclaration.getName() + "is not declared abstract");
            }
            if (this.hasBody()) {
                throw Jooc.error(this, "abstract method must not be implemented");
            }
        }
        if (this.isNative() && this.hasBody()) {
            throw Jooc.error(this, "native method must not be implemented");
        }
        if (!(this.isAbstract() || this.isNative() || this.hasBody())) {
            throw Jooc.error(this, "method must either be implemented or declared abstract or native");
        }
        if (!this.isStatic()) {
            ClassDeclaration currentClass = scope.getClassDeclaration();
            if (classDeclaration != null) {
                Type thisType = currentClass.getThisType();
                Parameter thisParam = new Parameter(null, new Ide("this"), new TypeRelation(null, thisType), null);
                this.fun.addImplicitParam(thisParam);
                Type superType = currentClass.getSuperType();
                if (superType != null) {
                    this.fun.addImplicitParam(new Parameter(null, new Ide("super"), new TypeRelation(null, superType), null));
                }
            }
        }
        this.fun.scope(scope);
        if (this.containsSuperConstructorCall()) {
            BlockStatement block = this.getBody();
            block.checkSuperConstructorCall();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.fun.analyze(this);
    }

    @Override
    protected int getAllowedModifiers() {
        return this.isConstructor() ? 1551 : 3839;
    }

    @Override
    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        FunctionDeclaration other;
        if (this.isGetterOrSetter() && oldNode instanceof FunctionDeclaration && (other = (FunctionDeclaration)oldNode).isGetterOrSetter() && this.isGetter() != other.isGetter()) {
            return;
        }
        super.handleDuplicateDeclaration(scope, oldNode);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.fun.getSymbol();
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this.isConstructor() ? this.getClassDeclaration() : super.resolveDeclaration();
    }

    public void setConstructor(boolean constructor) {
        this.isConstructor = constructor;
    }

    public boolean isContainsSuperConstructorCall() {
        return this.containsSuperConstructorCall;
    }
}

