/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.Type;

public class IdeWithTypeParam
extends Ide {
    private JooSymbol originalIde;
    private JooSymbol symDotLt;
    private Type type;
    private JooSymbol symGt;

    public IdeWithTypeParam(JooSymbol ide, JooSymbol symDotLt, Type type, JooSymbol symGt) {
        super(IdeWithTypeParam.withTypeParam(ide, type));
        this.originalIde = ide;
        this.symDotLt = symDotLt;
        this.type = type;
        this.symGt = symGt;
    }

    public JooSymbol getOriginalIde() {
        return this.originalIde;
    }

    public JooSymbol getSymDotLt() {
        return this.symDotLt;
    }

    public Type getType() {
        return this.type;
    }

    public JooSymbol getSymGt() {
        return this.symGt;
    }

    private static JooSymbol withTypeParam(JooSymbol ide, Type type) {
        return new JooSymbol(ide.sym, ide.getFileName(), ide.getLine(), ide.getColumn(), ide.getWhitespace(), ide.getText() + "$object", ide.getJooValue());
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIdeWithTypeParam(this);
    }

    @Override
    public void generateCodeAsExpr(JsWriter out) throws IOException {
        super.generateCodeAsExpr(out);
        out.beginComment();
        out.writeSymbol(this.symDotLt);
        out.writeSymbol(this.type.getIde().getIde());
        out.writeSymbol(this.symGt);
        out.endComment();
    }
}

