/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;

public class PathInputSource
extends DirectoryInputSource {
    private String name;
    private List<InputSource> entries;

    public static PathInputSource fromFiles(List<File> files, String[] rootDirs) throws IOException {
        ArrayList<InputSource> entries = new ArrayList<InputSource>();
        StringBuilder name = new StringBuilder();
        for (File file : files) {
            if (file.isDirectory()) {
                entries.add(new FileInputSource(file, file));
            } else if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                entries.add(new ZipFileInputSource(file, rootDirs));
            }
            if (name.length() != 0) {
                name.append(File.pathSeparatorChar);
            }
            name.append(file.getAbsolutePath());
        }
        return new PathInputSource(name.toString(), entries);
    }

    public PathInputSource(String name, List<InputSource> entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    public List<InputSource> list() {
        ArrayList<InputSource> result = new ArrayList<InputSource>();
        for (InputSource entry : this.entries) {
            result.addAll(entry.list());
        }
        return result;
    }

    @Override
    public InputSource getChild(String path) {
        ArrayList<InputSource> result = null;
        for (InputSource entry : this.entries) {
            InputSource child = entry.getChild(path);
            if (child == null) continue;
            if (!child.isDirectory()) {
                return child;
            }
            if (result == null) {
                result = new ArrayList<InputSource>();
            }
            result.add(child);
        }
        return result == null ? null : new PathInputSource("(" + this.getName() + ")" + path, result);
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }
}

