/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PostfixOpExpr;

public class DotExpr
extends PostfixOpExpr {
    private Ide ide;

    public DotExpr(Expr expr, JooSymbol symDot, Ide ide) {
        super(symDot, expr);
        this.ide = ide;
    }

    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitDotExpr(this);
    }

    public Ide getIde() {
        return this.ide;
    }

    public void scope(Scope scope) {
        super.scope(scope);
        this.getIde().scope(scope);
    }

    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        IdeDeclaration qualiferType = this.getArg().getType();
        if (qualiferType != null) {
            IdeDeclaration memberDeclaration = this.getArg().getType().resolvePropertyDeclaration(this.getIde().getName());
            if (memberDeclaration != null && memberDeclaration.isStatic()) {
                throw Jooc.error(this.getIde().getIde(), "static member used in dynamic context");
            }
            this.setType(memberDeclaration);
        }
    }
}

