/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jangaroo.jooc.model.ActionScriptModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.NamespaceModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.model.ReturnModel;
import net.jangaroo.utils.CompilerUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitModel
implements ActionScriptModel {
    private String packageName = "";
    private List<String> imports = new ArrayList<String>();
    private NamedModel primaryDeclaration;

    public CompilationUnitModel() {
    }

    public CompilationUnitModel(String packageName) {
        this.packageName = packageName;
    }

    public CompilationUnitModel(String packageName, NamedModel primaryDeclaration) {
        this(packageName);
        this.primaryDeclaration = primaryDeclaration;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public String getQName() {
        return CompilerUtils.qName(this.packageName, this.primaryDeclaration.getName());
    }

    public void setQName(String qName) {
        this.packageName = CompilerUtils.packageName(qName);
        this.primaryDeclaration.setName(CompilerUtils.className(qName));
    }

    public NamedModel getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public void setPrimaryDeclaration(NamedModel primaryDeclaration) {
        this.primaryDeclaration = primaryDeclaration;
    }

    public void addImport(String qName) {
        if (qName != null && qName.contains(".") && !qName.contains("<") && !this.imports.contains(qName) && !this.getPackage().equals(CompilerUtils.packageName(qName))) {
            this.imports.add(qName);
        }
    }

    public List<String> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    public void addImplicitImports() {
        this.visit(new ModelVisitor(){

            public void visitCompilationUnit(CompilationUnitModel compilationUnitModel) {
                compilationUnitModel.getPrimaryDeclaration().visit(this);
            }

            public void visitClass(ClassModel classModel) {
                CompilationUnitModel.this.addImport(classModel.getNamespace());
                CompilationUnitModel.this.addImport(classModel.getSuperclass());
                Iterator<Object> i$ = classModel.getInterfaces().iterator();
                while (i$.hasNext()) {
                    String anInterface = i$.next();
                    CompilationUnitModel.this.addImport(anInterface);
                }
                i$ = classModel.getMembers().iterator();
                while (i$.hasNext()) {
                    MemberModel memberModel = (MemberModel)i$.next();
                    memberModel.visit(this);
                }
            }

            public void visitField(FieldModel fieldModel) {
                CompilationUnitModel.this.addImport(fieldModel.getNamespace());
                CompilationUnitModel.this.addImport(fieldModel.getType());
            }

            public void visitProperty(PropertyModel propertyModel) {
                CompilationUnitModel.this.addImport(propertyModel.getNamespace());
                CompilationUnitModel.this.addImport(propertyModel.getType());
            }

            public void visitMethod(MethodModel methodModel) {
                CompilationUnitModel.this.addImport(methodModel.getNamespace());
                Iterator<ParamModel> i$ = methodModel.getParams().iterator();
                while (i$.hasNext()) {
                    ParamModel paramModel = i$.next();
                    paramModel.visit(this);
                }
                methodModel.getReturnModel().visit(this);
            }

            public void visitParam(ParamModel paramModel) {
                CompilationUnitModel.this.addImport(paramModel.getType());
            }

            public void visitReturn(ReturnModel returnModel) {
                CompilationUnitModel.this.addImport(returnModel.getType());
            }

            public void visitNamespace(NamespaceModel namespaceModel) {
            }

            public void visitAnnotation(AnnotationModel annotationModel) {
            }

            public void visitAnnotationProperty(AnnotationPropertyModel annotationPropertyModel) {
            }
        });
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitCompilationUnit(this);
    }

    public ClassModel getClassModel() {
        return this.primaryDeclaration instanceof ClassModel ? (ClassModel)this.primaryDeclaration : null;
    }
}

