/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.jangaroo.jooc.CheckAssignmentAndDeclationVisitor;
import net.jangaroo.jooc.CompilationResultImpl;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DependencyGraph;
import net.jangaroo.jooc.ImplementedMembersAnalyzer;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.api.CompilationResult;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TransitiveAstVisitor;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.jooc.cli.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.jooc.mxml.CatalogComponentsParser;
import net.jangaroo.jooc.mxml.CatalogGenerator;
import net.jangaroo.jooc.mxml.ComponentPackageManifestParser;
import net.jangaroo.jooc.mxml.ComponentPackageModel;
import net.jangaroo.jooc.mxml.MxmlComponentRegistry;
import net.jangaroo.properties.Propc;
import net.jangaroo.utils.CompilerUtils;

public class Jooc
extends JangarooParser
implements net.jangaroo.jooc.api.Jooc {
    public static final String PUBLIC_API_EXCLUSION_ANNOTATION_NAME = "ExcludeClass";
    public static final String PUBLIC_API_INCLUSION_ANNOTATION_NAME = "PublicApi";
    public static final String NATIVE_ANNOTATION_NAME = "Native";
    public static final String NATIVE_ANNOTATION_REQUIRE_PROPERTY = "require";
    public static final String USES_ANNOTATION_NAME = "Uses";
    public static final String MIXIN_ANNOTATION_NAME = "Mixin";
    public static final String BINDABLE_ANNOTATION_NAME = "Bindable";
    public static final String EXT_CONFIG_ANNOTATION_NAME = "ExtConfig";
    public static final String EMBED_ANNOTATION_NAME = "Embed";
    public static final String EMBED_ANNOTATION_SOURCE_PROPERTY = "source";
    public static final String RESOURCE_BUNDLE_ANNOTATION_NAME = "ResourceBundle";
    private List<FileInputSource> compileQueue = new ArrayList<FileInputSource>();

    public Jooc() {
        this(new JoocConfiguration());
    }

    public Jooc(JoocConfiguration config) {
        this(config, (CompileLog)new StdOutCompileLog());
    }

    public Jooc(JoocConfiguration config, CompileLog log) {
        super((ParserOptions)config, log);
    }

    public JoocConfiguration getConfig() {
        return (JoocConfiguration)super.getConfig();
    }

    public void setConfig(JoocConfiguration config) {
        super.setConfig((ParserOptions)config);
    }

    public CompilationResult run() {
        try {
            return this.run1();
        }
        catch (CompilerError e) {
            this.logCompilerError(e);
            return new CompilationResultImpl(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logCompilerError(e);
            return new CompilationResultImpl(2);
        }
    }

    private void logCompilerError(Throwable e) {
        boolean causedBy = false;
        for (Throwable current = e; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (causedBy) {
                message = "Caused by: " + message;
            }
            if (current instanceof CompilerError && ((CompilerError)current).getSymbol() != null) {
                this.log.error(((CompilerError)current).getSymbol(), message);
            } else {
                this.log.error(message);
            }
            causedBy = true;
        }
    }

    private CompilationResult run1() {
        Propc propertyClassGenerator;
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        File localizedOutputDirectory = this.getConfig().getLocalizedOutputDirectory();
        if (localizedOutputDirectory == null) {
            localizedOutputDirectory = new File(this.getConfig().getOutputDirectory().getParentFile(), "locale");
        }
        try {
            sourcePathInputSource = PathInputSource.fromFiles(this.getConfig().getSourcePath(), new String[]{""}, true);
            classPathInputSource = PathInputSource.fromFiles(this.getConfig().getClassPath(), new String[]{"", "META-INF/joo-api/"}, false);
            propertyClassGenerator = new Propc();
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        this.setUp(sourcePathInputSource, classPathInputSource);
        HashMap<File, File> outputFileMap = new HashMap<File, File>();
        try {
            this.setUpMxmlComponentRegistry(sourcePathInputSource, classPathInputSource);
            for (File sourceFile : this.getConfig().getSourceFiles()) {
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(this.getConfig(), false);
            CompilationUnitSinkFactory apiSinkFactory = null;
            if (this.getConfig().isGenerateApi()) {
                apiSinkFactory = this.createSinkFactory(this.getConfig(), true);
            }
            ImplementedMembersAnalyzer implementedMembersAnalyzer = new ImplementedMembersAnalyzer(this);
            for (InputSource compilationResultImpl : this.compileQueue) {
                CompilationUnit unit = this.importSource(compilationResultImpl);
                if (unit == null) continue;
                this.checkValidFileName(unit);
                unit.analyze(null);
                if (this.getConfig().getPublicApiViolationsMode() != PublicApiViolationsMode.ALLOW) {
                    this.reportPublicApiViolations(unit);
                }
                implementedMembersAnalyzer.analyzeImplementedMembers(unit);
                CheckAssignmentAndDeclationVisitor checkAssignmentAndDeclationVisitor = new CheckAssignmentAndDeclationVisitor(this.log);
                unit.visit(new TransitiveAstVisitor(checkAssignmentAndDeclationVisitor));
            }
            this.analyzeDependencies();
            for (InputSource inputSource : this.compileQueue) {
                CompilationUnit unit;
                File sourceFile = ((FileInputSource)inputSource).getFile();
                File outputFile = null;
                String sourceName = inputSource.getName();
                boolean isPropertiesSource = sourceName.endsWith(".properties");
                if (isPropertiesSource) {
                    outputFile = propertyClassGenerator.compile(sourceFile, this.getConfig().getSourcePath(), localizedOutputDirectory);
                }
                if ((unit = this.importSource(inputSource)) != null) {
                    IdeDeclaration primaryDeclaration = unit.getPrimaryDeclaration();
                    if (primaryDeclaration.getAnnotation(NATIVE_ANNOTATION_NAME) == null && !primaryDeclaration.isNative() && primaryDeclaration.getAnnotation(MIXIN_ANNOTATION_NAME) == null) {
                        outputFile = this.writeOutput(sourceFile, unit, codeSinkFactory, this.getConfig().isVerbose());
                    }
                    if (this.getConfig().isGenerateApi()) {
                        this.writeOutput(sourceFile, unit, apiSinkFactory, this.getConfig().isVerbose());
                        if (isPropertiesSource && this.isDefaultLocale(sourceName)) {
                            File apiOutputDirectory = this.getConfig().getApiOutputDirectory();
                            String relativeSourcePath = inputSource.getRelativePath();
                            File apiFile = new File(apiOutputDirectory, relativeSourcePath);
                            Files.copy(sourceFile.toPath(), apiFile.toPath(), new CopyOption[0]);
                        }
                    }
                }
                outputFileMap.put(sourceFile, outputFile);
            }
            this.compileQueue.clear();
            int result = this.log.hasErrors() ? 1 : 0;
            CompilationResultImpl compilationResultImpl = new CompilationResultImpl(result, outputFileMap);
            return compilationResultImpl;
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        finally {
            this.tearDown();
        }
    }

    private boolean isDefaultLocale(String sourceName) {
        return sourceName.indexOf(95) < 0;
    }

    private void checkValidFileName(CompilationUnit unit) {
        String qname;
        String expectedPath;
        InputSource source = this.getInputSource(unit);
        if (!source.getName().endsWith(".as")) {
            return;
        }
        String path = source.getRelativePath();
        if (path != null && !(expectedPath = CompilerUtils.fileNameFromQName((String)(qname = unit.getPrimaryDeclaration().getQualifiedNameStr()), (char)File.separatorChar, (String)".as")).equals(path)) {
            Jooc.warning(unit.getSymbol(), String.format("expected '%s' as the file name for %s, found: '%s'. -sourcepath not set (correctly)?", expectedPath, qname, path));
        }
    }

    private void analyzeDependencies() throws IOException {
        DependencyGraph dependencyGraph = this.makeDependencyGraph();
        dependencyGraph.analyze();
        File reportOutputDirectory = this.getConfig().getReportOutputDirectory();
        if (reportOutputDirectory != null) {
            File dependencyGraphFile = new File(reportOutputDirectory, "dependencies.graphml");
            try {
                dependencyGraph.writeDependencyGraphToFile(dependencyGraphFile);
            }
            catch (IOException e) {
                this.logCompilerError(e);
            }
        }
        if (dependencyGraph.hasErrors()) {
            if (reportOutputDirectory != null) {
                File errorGraphFile = new File(reportOutputDirectory, "cycles.graphml");
                try {
                    dependencyGraph.writeErrorGraphToFile(errorGraphFile);
                    this.log.error("A dependency graph of classes with dependency errors has been written to " + errorGraphFile.getAbsolutePath() + ".");
                }
                catch (IOException e) {
                    this.logCompilerError(e);
                }
            }
            throw Jooc.error(dependencyGraph.createDependencyError());
        }
    }

    private DependencyGraph makeDependencyGraph() throws IOException {
        DependencyGraph dependencyGraph = new DependencyGraph();
        HashSet<CompilationUnit> processedCompilationUnits = new HashSet<CompilationUnit>();
        HashSet<CompilationUnit> unprocessedCompilationUnits = new HashSet<CompilationUnit>(this.getCompilationUnits());
        while (!unprocessedCompilationUnits.isEmpty()) {
            for (CompilationUnit compilationUnit : unprocessedCompilationUnits) {
                if (!processedCompilationUnits.add(compilationUnit) || !compilationUnit.isInSourcePath()) continue;
                dependencyGraph.fillInDependencies(compilationUnit);
            }
            unprocessedCompilationUnits = new HashSet<CompilationUnit>(this.getCompilationUnits());
            unprocessedCompilationUnits.removeAll(processedCompilationUnits);
        }
        return dependencyGraph;
    }

    private void setUpMxmlComponentRegistry(InputSource sourcePathInputSource, InputSource classPathInputSource) throws IOException {
        List<InputSource> children = classPathInputSource.getChildren("catalog.xml");
        CatalogComponentsParser catalogParser = new CatalogComponentsParser(this.getMxmlComponentRegistry());
        for (InputSource child : children) {
            catalogParser.parse(child.getInputStream());
        }
        MxmlComponentRegistry localMxmlComponentRegistry = new MxmlComponentRegistry();
        List namespaces = this.getConfig().getNamespaces();
        for (NamespaceConfiguration namespace : namespaces) {
            File componentPackageManifest = namespace.getManifest();
            InputSource componentPackageManifestInputSource = componentPackageManifest == null ? sourcePathInputSource.getChild("manifest.xml") : new FileInputSource(componentPackageManifest, false);
            if (componentPackageManifestInputSource == null) continue;
            InputStream manifestInputStream = componentPackageManifestInputSource.getInputStream();
            ComponentPackageModel componentPackageModel = new ComponentPackageManifestParser(namespace.getUri()).parse(manifestInputStream);
            this.getMxmlComponentRegistry().add(componentPackageModel);
            localMxmlComponentRegistry.add(componentPackageModel);
        }
        File catalogOutputDirectory = this.getConfig().getCatalogOutputDirectory();
        if (catalogOutputDirectory != null && !localMxmlComponentRegistry.getComponentPackageModels().isEmpty()) {
            catalogOutputDirectory.mkdirs();
            new CatalogGenerator(localMxmlComponentRegistry).generateCatalog(new File(catalogOutputDirectory, "catalog.xml"));
        }
    }

    private void reportPublicApiViolations(CompilationUnit unit) {
        HashSet<String> dependenciesForPublicAPICheck = new HashSet<String>(unit.getDependencies());
        dependenciesForPublicAPICheck.addAll(unit.getPublicApiDependencies());
        for (String qName : dependenciesForPublicAPICheck) {
            CompilationUnit compilationUnit = this.getCompilationUnit(qName);
            if (!(this.getInputSource(compilationUnit) instanceof ZipEntryInputSource) || compilationUnit.getPackageDeclaration().getAnnotation(PUBLIC_API_EXCLUSION_ANNOTATION_NAME) == null) continue;
            String msg = "PUBLIC API VIOLATION: " + compilationUnit.getPrimaryDeclaration().getQualifiedNameStr();
            File sourceFile = new File(unit.getSymbol().getFileName());
            if (this.getConfig().getPublicApiViolationsMode() == PublicApiViolationsMode.WARN) {
                JangarooParser.warning(msg, sourceFile);
                continue;
            }
            throw JangarooParser.error(msg, sourceFile);
        }
    }

    public File writeOutput(File sourceFile, CompilationUnit compilationUnit, CompilationUnitSinkFactory writerFactory, boolean verbose) throws CompilerError {
        CompilationUnitSink sink = writerFactory.createSink(compilationUnit.getPackageDeclaration(), compilationUnit.getPrimaryDeclaration(), sourceFile, verbose);
        return sink.writeOutput(compilationUnit);
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, boolean generateActionScriptApi) {
        AbstractCompilationUnitSinkFactory codeSinkFactory;
        if (!generateActionScriptApi && config.isMergeOutput()) {
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory((JoocOptions)config, config.getOutputFile(), this, this);
        } else {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String suffix = generateActionScriptApi ? ".as" : ".js";
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory((JoocOptions)config, outputDirectory, generateActionScriptApi, suffix, this, this);
        }
        return codeSinkFactory;
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
            case 5: {
                return "illegal option value";
            }
        }
        return "unknown result code";
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error("Input file is a directory.", file);
        }
        File sourceDir = this.getConfig().findSourceDir(file);
        FileInputSource inputSource = new FileInputSource(sourceDir, file, true);
        this.compileQueue.add(inputSource);
        this.importSource(inputSource);
    }

    public static int run(String[] argv, CompileLog log) {
        try {
            JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
            JoocConfiguration config = commandLineParser.parse(argv);
            if (config != null) {
                return new Jooc(config, log).run().getResultCode();
            }
        }
        catch (CommandLineParseException e) {
            System.out.println(e.getMessage());
            return e.getExitCode();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Jooc.run(argv, new StdOutCompileLog());
        if (result != 0) {
            System.exit(result);
        }
    }
}

