/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.utils.AS3Type;

public class ExpressionType {
    private final AS3Type as3Type;
    private final TypeDeclaration declaration;
    private final ExpressionType typeParameter;

    public ExpressionType(@Nonnull TypeDeclaration declaration) {
        this(declaration, null);
    }

    public ExpressionType(@Nonnull TypeDeclaration declaration, @Nullable ExpressionType typeParameter) {
        this.as3Type = ExpressionType.computeAS3Type(declaration);
        this.declaration = declaration;
        this.typeParameter = typeParameter;
    }

    @Nonnull
    private static AS3Type computeAS3Type(TypeDeclaration declaration) {
        String typeQName = declaration.getQualifiedNameStr();
        AS3Type as3Type = AS3Type.typeByName((String)typeQName);
        return as3Type != null ? as3Type : AS3Type.OBJECT;
    }

    public AS3Type getAS3Type() {
        return this.as3Type;
    }

    @Nonnull
    public TypeDeclaration getDeclaration() {
        return this.declaration;
    }

    @Nullable
    public ExpressionType getTypeParameter() {
        return this.typeParameter;
    }

    public boolean isArrayLike() {
        return this.as3Type == AS3Type.ARRAY || this.as3Type == AS3Type.VECTOR;
    }

    public IdeDeclaration resolvePropertyDeclaration(String memberName) {
        if (this.as3Type == AS3Type.CLASS && this.typeParameter != null) {
            return this.typeParameter.getDeclaration().getStaticMemberDeclaration(memberName);
        }
        return this.getDeclaration().resolvePropertyDeclaration(memberName);
    }

    public boolean isAssignableTo(@Nonnull ExpressionType toCheck) {
        ClassDeclaration toCheckClassDeclaration;
        if (this.as3Type == null || AS3Type.ANY.equals((Object)this.as3Type) || AS3Type.BOOLEAN.equals((Object)this.as3Type)) {
            return true;
        }
        ClassDeclaration classDeclaration = toCheckClassDeclaration = toCheck.getDeclaration() instanceof ClassDeclaration ? (ClassDeclaration)toCheck.getDeclaration() : null;
        if (toCheckClassDeclaration != null && toCheckClassDeclaration.isObject()) {
            return true;
        }
        AS3Type expectedAS3Type = toCheck.getAS3Type();
        if (!AS3Type.OBJECT.equals((Object)this.as3Type) && this.as3Type.equals((Object)expectedAS3Type)) {
            return true;
        }
        if (ExpressionType.isNumber(expectedAS3Type) && ExpressionType.isNumber(this.as3Type)) {
            return true;
        }
        if (AS3Type.VECTOR.equals((Object)expectedAS3Type)) {
            return true;
        }
        if (toCheckClassDeclaration == null || !(this.getDeclaration() instanceof ClassDeclaration)) {
            return this.as3Type.equals((Object)expectedAS3Type);
        }
        ClassDeclaration currentDeclaration = (ClassDeclaration)this.getDeclaration();
        if (AS3Type.CLASS.equals((Object)this.as3Type) && this.getTypeParameter() != null) {
            TypeDeclaration typeDeclaration = this.getTypeParameter().getDeclaration();
            if (typeDeclaration instanceof ClassDeclaration) {
                currentDeclaration = (ClassDeclaration)typeDeclaration;
            } else {
                return true;
            }
        }
        return currentDeclaration.isAssignableTo((ClassDeclaration)toCheck.getDeclaration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionType that = (ExpressionType)o;
        return this.declaration.equals(that.declaration) && (this.typeParameter != null ? this.typeParameter.equals(that.typeParameter) : that.typeParameter == null);
    }

    public int hashCode() {
        int result = this.declaration.hashCode();
        result = 31 * result + (this.typeParameter != null ? this.typeParameter.hashCode() : 0);
        return result;
    }

    public static boolean isNumber(AS3Type type) {
        return AS3Type.NUMBER.equals((Object)type) || AS3Type.INT.equals((Object)type) || AS3Type.UINT.equals((Object)type);
    }
}

