/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jangaroo.jooc.model.ActionScriptModel;
import net.jangaroo.jooc.model.AnnotatedModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.NamespaceModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.model.ReturnModel;
import net.jangaroo.jooc.model.TypedModel;
import net.jangaroo.jooc.model.ValuedModel;
import net.jangaroo.utils.CompilerUtils;

public class ActionScriptCodeGeneratingModelVisitor
implements ModelVisitor {
    public static final Pattern LEADING_ASDOC_WHITESPACE_PATTERN = Pattern.compile("\\s*\\* ?(.*)");
    private final PrintWriter output;
    private CompilationUnitModel compilationUnitModel;
    private boolean skipAsDoc;
    private String indent = "";
    private static List<String> PARAM_SUPPRESSING_ASDOC_TAGS = Arrays.asList("@inheritDoc", "@private");

    public ActionScriptCodeGeneratingModelVisitor(Writer writer) {
        this.output = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public ActionScriptCodeGeneratingModelVisitor(Writer writer, boolean skipAsDoc) {
        this(writer);
        this.skipAsDoc = skipAsDoc;
    }

    public void setCompilationUnitModel(CompilationUnitModel compilationUnitModel) {
        this.compilationUnitModel = compilationUnitModel;
    }

    @Override
    public void visitCompilationUnit(CompilationUnitModel compilationUnitModel) {
        this.setCompilationUnitModel(compilationUnitModel);
        this.output.printf("package %s {%n", compilationUnitModel.getPackage());
        this.indent = "";
        for (String anImport : compilationUnitModel.getImports()) {
            this.output.printf("import %s;%n", anImport);
        }
        this.output.println();
        for (String aDependency : compilationUnitModel.getDependenciesInModule()) {
            this.output.printf("[%s(\"%s\")]%n", "Uses", aDependency);
        }
        compilationUnitModel.getPrimaryDeclaration().visit(this);
        this.indent = "";
        this.output.print("}");
        this.output.close();
    }

    @Override
    public void visitClass(ClassModel classModel) {
        this.visitAnnotations(classModel);
        this.output.print(classModel.getAnnotationCode());
        this.printAsdoc(classModel.getAsdoc());
        this.printToken(classModel.getNamespace());
        this.printTokenIf(classModel.isFinal(), "final");
        this.printTokenIf(classModel.isDynamic(), "dynamic");
        this.printToken(classModel.isInterface(), "interface", "class");
        this.printToken(classModel.getName());
        if (!classModel.isInterface() && !ActionScriptCodeGeneratingModelVisitor.isEmpty(classModel.getSuperclass())) {
            this.output.printf("extends %s ", classModel.getSuperclass());
        }
        if (!classModel.getInterfaces().isEmpty()) {
            this.printToken(classModel.isInterface(), "extends", "implements");
            List<String> tokens = classModel.getInterfaces();
            this.output.print(tokens.get(0));
            for (String token : tokens.subList(1, tokens.size())) {
                this.output.print(", ");
                this.output.print(token);
            }
            this.output.print(" ");
        }
        this.output.print("{");
        this.output.print(classModel.getBodyCode());
        this.indent = "  ";
        for (MemberModel member : classModel.getMembers()) {
            this.output.println();
            member.visit(this);
        }
        this.indent = "";
        this.output.println("}");
    }

    @Override
    public void visitNamespace(NamespaceModel namespaceModel) {
        this.visitAnnotations(namespaceModel);
        this.printAsdoc(namespaceModel.getAsdoc());
        this.printToken(namespaceModel.getNamespace());
        this.printToken("namespace");
        this.output.print(namespaceModel.getName());
        this.generateValue(namespaceModel);
        this.output.println(";");
    }

    private void visitAnnotations(AnnotatedModel annotatedModel) {
        for (AnnotationModel annotation : annotatedModel.getAnnotations()) {
            annotation.visit(this);
        }
    }

    private void printParameterList(List<? extends ActionScriptModel> models) {
        this.output.print("(");
        boolean first = true;
        for (ActionScriptModel actionScriptModel : models) {
            if (first) {
                first = false;
            } else {
                this.output.print(", ");
            }
            actionScriptModel.visit(this);
        }
        this.output.print(")");
    }

    private void printTokenIf(boolean flag, String token) {
        if (flag) {
            this.printToken(token);
        }
    }

    private void printToken(boolean flag, String trueToken, String falseToken) {
        this.printToken(flag ? trueToken : falseToken);
    }

    private void printToken(String token) {
        this.output.printf("%s ", token);
    }

    private void indent() {
        this.output.print(this.indent);
    }

    public void flush() {
        this.output.flush();
    }

    @Override
    public void visitField(FieldModel fieldModel) {
        this.visitAnnotations(fieldModel);
        this.printAsdoc(fieldModel.getAsdoc());
        this.indent();
        this.printToken(fieldModel.getNamespace());
        this.printTokenIf(fieldModel.isStatic(), "static");
        this.printToken(fieldModel.isConst(), "const", "var");
        this.output.print(fieldModel.getName());
        this.generateType(fieldModel);
        this.generateValue(fieldModel);
        this.output.println(";");
    }

    @Override
    public void visitProperty(PropertyModel propertyModel) {
        throw new IllegalStateException("PropertyModel should not be visited by code generator.");
    }

    @Override
    public void visitMethod(MethodModel methodModel) {
        this.visitAnnotations(methodModel);
        StringBuilder asdoc = new StringBuilder();
        if (methodModel.getAsdoc() != null) {
            asdoc.append(methodModel.getAsdoc());
        }
        ReturnModel returnModel = methodModel.getReturnModel();
        if (!PARAM_SUPPRESSING_ASDOC_TAGS.contains(asdoc.toString())) {
            StringBuilder emptyParamsASDoc = new StringBuilder();
            for (ParamModel paramModel : methodModel.getParams()) {
                boolean textEmpty = ActionScriptCodeGeneratingModelVisitor.isEmpty(paramModel.getAsdoc());
                String atParamName = "\n@param " + paramModel.getName();
                if (textEmpty) {
                    emptyParamsASDoc.append(atParamName);
                    continue;
                }
                if (emptyParamsASDoc.length() > 0) {
                    asdoc.append(emptyParamsASDoc.toString());
                    emptyParamsASDoc.setLength(0);
                }
                asdoc.append(atParamName).append(" ").append(paramModel.getAsdoc());
            }
            if (!"void".equals(returnModel.getType()) && !ActionScriptCodeGeneratingModelVisitor.isEmpty(returnModel.getAsdoc())) {
                asdoc.append("\n@return ").append(returnModel.getAsdoc());
            }
        }
        this.printAsdoc(asdoc.toString());
        this.indent();
        this.printTokenIf(methodModel.isOverride(), "override");
        String methodBody = methodModel.getBody();
        if (!this.isPrimaryDeclarationAnInterface()) {
            this.printToken(methodModel.getNamespace());
            this.printTokenIf(methodModel.isStatic(), "static");
            this.printTokenIf(methodModel.isFinal(), "final");
            this.printTokenIf(methodBody == null, "native");
        }
        this.printToken("function");
        if (methodModel.getMethodType() != null) {
            this.printToken(methodModel.getMethodType().toString());
        }
        this.output.print(methodModel.getName());
        this.printParameterList(methodModel.getParams());
        returnModel.visit(this);
        if (methodBody != null) {
            this.output.printf(" {%n    %s%n  }%n", methodModel.getBody());
        } else {
            this.output.println(";");
        }
    }

    @Override
    public void visitParam(ParamModel paramModel) {
        if (paramModel.isRest()) {
            this.output.print("...");
        }
        this.output.print(paramModel.getName());
        if (!paramModel.isRest()) {
            this.generateType(paramModel);
            this.generateValue(paramModel);
        }
    }

    @Override
    public void visitReturn(ReturnModel returnModel) {
        this.generateType(returnModel);
    }

    @Override
    public void visitAnnotation(AnnotationModel annotationModel) {
        this.printAsdoc(annotationModel.getAsdoc());
        this.indent();
        this.output.print("[" + annotationModel.getName());
        if (!annotationModel.getProperties().isEmpty()) {
            this.printParameterList(annotationModel.getProperties());
        }
        this.output.println("]");
    }

    @Override
    public void visitAnnotationProperty(AnnotationPropertyModel annotationPropertyModel) {
        String name = annotationPropertyModel.getName();
        String value = annotationPropertyModel.getValue();
        String unquoted = CompilerUtils.unquote((String)value);
        if (unquoted != null) {
            String quote = value.substring(0, 1);
            value = quote + unquoted.replaceAll("<", "&lt;").replaceAll("'", "&#39;") + quote;
        }
        if (ActionScriptCodeGeneratingModelVisitor.isEmpty(name)) {
            this.output.print(value);
        } else if (ActionScriptCodeGeneratingModelVisitor.isEmpty(value)) {
            this.output.print(name);
        } else {
            this.output.printf("%s = %s", name, value);
        }
    }

    private void printAsdoc(String asdoc) {
        if (!this.skipAsDoc && asdoc != null && asdoc.trim().length() > 0) {
            this.indent();
            this.output.println("/**");
            LinkedHashSet<String> atSeeLines = new LinkedHashSet<String>();
            for (String line : asdoc.trim().split("\n")) {
                Matcher matcher = LEADING_ASDOC_WHITESPACE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    line = matcher.group(1);
                }
                line = line.replaceAll("([^\\s*{])@", "$1&#64;");
                line = line.replaceAll("@([^a-zA-Z])", "&#64;$1");
                String printedLine = this.indent + " " + ("* " + line).trim();
                if (line.startsWith("@see ") || line.startsWith("@eventType ")) {
                    atSeeLines.add(printedLine);
                    continue;
                }
                this.output.println(printedLine);
            }
            for (String atSeeLine : atSeeLines) {
                this.output.println(atSeeLine);
            }
            this.output.println(this.indent + " */");
        }
    }

    private boolean isPrimaryDeclarationAnInterface() {
        return this.compilationUnitModel.getPrimaryDeclaration() instanceof ClassModel && ((ClassModel)this.compilationUnitModel.getPrimaryDeclaration()).isInterface();
    }

    private void generateType(TypedModel typedModel) {
        if (!ActionScriptCodeGeneratingModelVisitor.isEmpty(typedModel.getType())) {
            this.output.print(":" + typedModel.getType());
        }
    }

    private void generateValue(ValuedModel valuedModel) {
        if (!ActionScriptCodeGeneratingModelVisitor.isEmpty(valuedModel.getValue())) {
            this.output.print(" = " + valuedModel.getValue());
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void main(String[] args) {
        ClassModel classModel = new ClassModel("com.acme.Foo");
        classModel.setAsdoc("This is the Foo class.");
        AnnotationModel annotation = new AnnotationModel("ExtConfig", new AnnotationPropertyModel("target", "'foo.Bar'"));
        classModel.addAnnotation(annotation);
        FieldModel field = new FieldModel("FOOBAR");
        field.setType("String");
        field.setConst(true);
        field.setStatic(true);
        field.setNamespace("private");
        field.setAsdoc("A constant for foo bar.");
        field.setValue("'foo bar baz'");
        classModel.addMember(field);
        MethodModel method = new MethodModel();
        method.setName("doFoo");
        method.setAsdoc("Some method.");
        method.setBody("trace('foo');");
        ParamModel param = new ParamModel();
        param.setName("foo");
        param.setType("com.acme.sub.Bar");
        param.setValue("null");
        method.setParams(Collections.singletonList(param));
        method.setType("int");
        classModel.addMember(method);
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName("baz");
        propertyModel.setType("String");
        propertyModel.setAsdoc("The baz is a string.");
        classModel.addMember(propertyModel);
        StringWriter stringWriter = new StringWriter();
        classModel.visit(new ActionScriptCodeGeneratingModelVisitor(stringWriter));
        System.out.println("Result:\n" + stringWriter);
    }
}

