/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.types;

import java.util.List;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.types.ExpressionType;

public class FunctionSignature
extends ExpressionType {
    private final int minArgumentCount;
    private final boolean hasRest;
    private final List<ExpressionType> parameterTypes;

    public FunctionSignature(@Nonnull TypeDeclaration functionType, int minArgumentCount, boolean hasRest, List<ExpressionType> parameterTypes, ExpressionType returnType) {
        super(functionType, returnType);
        this.minArgumentCount = minArgumentCount;
        this.hasRest = hasRest;
        this.parameterTypes = parameterTypes;
    }

    public int getMinArgumentCount() {
        return this.minArgumentCount;
    }

    public boolean hasRest() {
        return this.hasRest;
    }

    public List<ExpressionType> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionSignature that = (FunctionSignature)o;
        return this.minArgumentCount == that.minArgumentCount && this.hasRest == that.hasRest && this.parameterTypes.equals(that.parameterTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minArgumentCount;
        result = 31 * result + (this.hasRest ? 1 : 0);
        result = 31 * result + this.parameterTypes.hashCode();
        return result;
    }
}

