/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;

class ImplementedMembersAnalyzer {
    private Jooc jooc;
    private Collection<String> inspected = new HashSet<String>();
    private Multimap<String, FunctionDeclaration> membersByInterfaceQName = LinkedHashMultimap.create();
    private Multimap<String, FunctionDeclaration> membersByClassQName = LinkedHashMultimap.create();

    ImplementedMembersAnalyzer(Jooc jooc) {
        this.jooc = jooc;
    }

    void analyzeImplementedMembers(CompilationUnit compilationUnit) {
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        String qName = primaryDeclaration.getQualifiedNameStr();
        if (primaryDeclaration instanceof ClassDeclaration && this.inspected.add(qName)) {
            this.visitClassDeclaration((ClassDeclaration)primaryDeclaration);
        }
    }

    void visitClassDeclaration(ClassDeclaration classDeclaration) {
        ClassDeclaration superTypeDeclaration;
        String superClassQName;
        String qName = classDeclaration.getQualifiedNameStr();
        boolean isInterface = classDeclaration.isInterface();
        LinkedHashSet toBeImplemented = new LinkedHashSet();
        Implements optImplements = classDeclaration.getOptImplements();
        if (null != optImplements) {
            for (CommaSeparatedList<Ide> localSuperTypes = optImplements.getSuperTypes(); localSuperTypes != null; localSuperTypes = localSuperTypes.getTail()) {
                superClassQName = localSuperTypes.getHead().getDeclaration().getQualifiedNameStr();
                this.analyzeImplementedMembers(this.jooc.getCompilationUnit(superClassQName));
                Collection superClassMembers = this.membersByInterfaceQName.get((Object)superClassQName);
                if (isInterface) {
                    this.membersByInterfaceQName.putAll((Object)qName, (Iterable)superClassMembers);
                    continue;
                }
                toBeImplemented.addAll(superClassMembers);
            }
        }
        if (null != (superTypeDeclaration = classDeclaration.getSuperTypeDeclaration())) {
            superClassQName = superTypeDeclaration.getQualifiedNameStr();
            this.analyzeImplementedMembers(this.jooc.getCompilationUnit(superClassQName));
            this.membersByClassQName.putAll((Object)qName, (Iterable)this.membersByClassQName.get((Object)superClassQName));
        }
        ClassDeclaration classModel = (ClassDeclaration)this.jooc.resolveCompilationUnit(qName).getPrimaryDeclaration();
        Collection<FunctionDeclaration> methodModels = classModel.getMethods();
        if (isInterface) {
            this.membersByInterfaceQName.putAll((Object)qName, methodModels);
        } else {
            FunctionDeclaration constructor = classModel.getConstructor();
            Iterable publicNonStaticMethods = Iterables.filter(methodModels, (Predicate)Predicates.and((Predicate)new Predicate<FunctionDeclaration>(){

                public boolean apply(@Nullable FunctionDeclaration input) {
                    return !input.isStatic() && input.isPublic();
                }
            }, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)constructor))));
            this.membersByClassQName.putAll((Object)qName, publicNonStaticMethods);
        }
        if (!isInterface) {
            Collection implemented = this.membersByClassQName.get((Object)qName);
            toBeImplemented.addAll(this.membersByInterfaceQName.get((Object)qName));
            toBeImplemented.removeAll(implemented);
            if (!toBeImplemented.isEmpty()) {
                throw JangarooParser.error(optImplements, "Does not implement " + Iterables.transform(toBeImplemented, (Function)new Function<TypedIdeDeclaration, String>(){

                    @Nullable
                    public String apply(@Nullable TypedIdeDeclaration input) {
                        if (input instanceof FunctionDeclaration && ((FunctionDeclaration)input).isGetterOrSetter()) {
                            return ((FunctionDeclaration)input).getSymGetOrSet().getText() + " " + input.getName();
                        }
                        return input == null ? null : input.getName();
                    }
                }));
            }
        }
    }
}

