/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;

public class PropertyDeclaration
extends TypedIdeDeclaration {
    private FunctionDeclaration getter;
    private FunctionDeclaration setter;

    PropertyDeclaration(FunctionDeclaration getter, FunctionDeclaration setter) {
        super(PropertyDeclaration.computeAnnotationsAndModifiers(getter, setter), getter.getIde(), getter.getOptTypeRelation());
        this.getter = getter;
        this.setter = setter;
    }

    private static AnnotationsAndModifiers computeAnnotationsAndModifiers(FunctionDeclaration getter, FunctionDeclaration setter) {
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(getter.getAnnotations());
        allAnnotations.addAll(setter.getAnnotations());
        return new AnnotationsAndModifiers(allAnnotations, Arrays.asList(getter.getSymModifiers()));
    }

    public FunctionDeclaration getGetter() {
        return this.getter;
    }

    public FunctionDeclaration getSetter() {
        return this.setter;
    }

    public FunctionDeclaration getAccessor(boolean returnSetter) {
        return returnSetter ? this.setter : this.getter;
    }

    public Iterable<FunctionDeclaration> getMethods() {
        return Arrays.asList(this.getter, this.setter);
    }

    @Override
    public boolean isWritable() {
        return this.getSetter() != null;
    }

    @Override
    public boolean isClassMember() {
        return this.getter.isClassMember();
    }

    @Override
    public ClassDeclaration getClassDeclaration() {
        return this.getter.getClassDeclaration();
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        throw new IllegalStateException("PropertyDeclaration is virtual and must not appear in AST.");
    }

    static TypedIdeDeclaration addDeclaration(FunctionDeclaration getterOrSetter, IdeDeclaration additionalDeclaration) {
        if (additionalDeclaration instanceof PropertyDeclaration) {
            PropertyDeclaration additionalPropertyDeclaration = (PropertyDeclaration)additionalDeclaration;
            IdeDeclaration ideDeclaration = additionalDeclaration = getterOrSetter.isGetter() ? additionalPropertyDeclaration.getSetter() : additionalPropertyDeclaration.getGetter();
        }
        if (additionalDeclaration instanceof FunctionDeclaration) {
            FunctionDeclaration additionalFunctionDeclaration = (FunctionDeclaration)additionalDeclaration;
            if (additionalFunctionDeclaration.isGetter()) {
                if (getterOrSetter.isSetter()) {
                    return new PropertyDeclaration(additionalFunctionDeclaration, getterOrSetter);
                }
                return getterOrSetter;
            }
            if (additionalFunctionDeclaration.isSetter()) {
                if (getterOrSetter.isGetter()) {
                    return new PropertyDeclaration(getterOrSetter, additionalFunctionDeclaration);
                }
                return getterOrSetter;
            }
        }
        return null;
    }
}

