/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import java.util.List;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.mxml.MxmlParserHelper;
import net.jangaroo.jooc.mxml.ast.MxmlAstUtils;
import net.jangaroo.jooc.mxml.ast.MxmlCompilationUnit;
import net.jangaroo.jooc.mxml.ast.RootElementProcessor;
import net.jangaroo.jooc.mxml.ast.XmlElement;

class ClassDeclarationBuilder {
    private final JangarooParser parser;
    private final MxmlParserHelper mxmlParserHelper;
    private final MxmlCompilationUnit unit;
    private final List<Directive> classBodyDirectives;

    ClassDeclarationBuilder(@Nonnull JangarooParser parser2, @Nonnull MxmlParserHelper mxmlParserHelper, @Nonnull MxmlCompilationUnit unit) {
        this.parser = parser2;
        this.mxmlParserHelper = mxmlParserHelper;
        this.unit = unit;
        this.classBodyDirectives = unit.getClassBodyDirectives();
    }

    ClassDeclaration build() {
        RootElementProcessor rootElementProcessor = this.unit.getRootElementProcessor();
        String classQName = this.unit.getQualifiedNameStr();
        XmlElement rootNode = this.unit.getRootNode();
        JooSymbol rootNodeSymbol = rootNode.getSymbol();
        Extends ext = this.mxmlParserHelper.parseExtends(this.parser, rootNode, classQName);
        Implements impl = null;
        JooSymbol implSymbol = rootElementProcessor.getImpl();
        if (null != implSymbol) {
            impl = this.mxmlParserHelper.parseImplements(implSymbol);
        }
        this.handleScripts(rootElementProcessor.getScripts());
        return MxmlAstUtils.createClassDeclaration(classQName, rootNodeSymbol, ext, impl, this.classBodyDirectives, this.unit.getInputSource());
    }

    private void handleScripts(@Nonnull List<JooSymbol> scripts) {
        for (JooSymbol jooSymbol : scripts) {
            ClassBody classBody = this.mxmlParserHelper.parseClassBody(jooSymbol);
            List<Directive> parsedClassBodyDirectives = classBody.getDirectives();
            if (null != parsedClassBodyDirectives) {
                this.classBodyDirectives.addAll(parsedClassBodyDirectives);
                continue;
            }
            this.parser.getLog().warning((FilePosition)jooSymbol, "element is empty");
        }
    }
}

