/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.backend.ModuleResolverBase;
import net.jangaroo.jooc.config.SearchAndReplace;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.utils.CompilerUtils;

public class TypeScriptModuleResolver
extends ModuleResolverBase {
    private final List<SearchAndReplace> npmPackageNameReplacers;

    public TypeScriptModuleResolver(CompilationUnitResolver compilationUnitModelResolver, List<SearchAndReplace> npmPackageNameReplacers) {
        super(compilationUnitModelResolver);
        this.npmPackageNameReplacers = npmPackageNameReplacers;
    }

    public String getDefaultImportName(IdeDeclaration declaration) {
        String targetName;
        Annotation renameAnnotation = declaration.getAnnotation("Rename");
        if (renameAnnotation != null && (targetName = TypeScriptModuleResolver.getNativeAnnotationValue(renameAnnotation)) != null && !targetName.isEmpty()) {
            return CompilerUtils.className((String)targetName);
        }
        String nativeName = TypeScriptModuleResolver.getNonRequireNativeName(declaration);
        if (nativeName != null) {
            return nativeName;
        }
        return declaration.getName();
    }

    public String getRequireModuleName(CompilationUnit compilationUnit, IdeDeclaration declaration) {
        String npmPackageName;
        String moduleName;
        block7: {
            block6: {
                moduleName = this.getRequireModulePath(declaration);
                if (moduleName == null) {
                    return null;
                }
                InputSource importedInputSource = declaration.getCompilationUnit().getInputSource();
                FileInputSource currentInputSource = (FileInputSource)compilationUnit.getInputSource();
                if (importedInputSource instanceof FileInputSource) {
                    File currentTargetFile;
                    FileInputSource fileInputSource = (FileInputSource)importedInputSource;
                    boolean isModule = this.getRequireModulePath(compilationUnit.getPrimaryDeclaration()) != null;
                    File sourceDir = currentInputSource.getSourceDir();
                    File file = currentTargetFile = isModule ? CompilerUtils.fileFromQName((String)compilationUnit.getPrimaryDeclaration().getExtNamespaceRelativeTargetQualifiedNameStr(), (File)sourceDir, (String)".ts") : new File(sourceDir, "index.d.ts");
                    if (fileInputSource.getSourceDir().equals(sourceDir) || !sourceDir.getPath().replace(File.separatorChar, '/').endsWith("src/test/joo")) {
                        return this.computeRelativeModulePath(currentTargetFile, new File(sourceDir, moduleName));
                    }
                    return this.computeRelativeModulePath(currentTargetFile, new File(sourceDir, "../src/" + moduleName));
                }
                if (!(importedInputSource instanceof ZipEntryInputSource)) {
                    throw new IllegalStateException("The input source for a compilation unit was not a file");
                }
                npmPackageName = ((ZipEntryInputSource)importedInputSource).getZipFileInputSource().getSenchaPackageName();
                if (npmPackageName == null) {
                    return null;
                }
                if (!npmPackageName.startsWith("net.jangaroo__")) break block6;
                npmPackageName = npmPackageName.replace("net.jangaroo__", "@jangaroo/");
                if (!(npmPackageName = npmPackageName.replace("/jangaroo-runtime", "/runtime")).endsWith("ext-as")) break block7;
                npmPackageName = npmPackageName.replace("/ext-as", moduleName.startsWith("joo/") ? "" : "/ext-ts");
                break block7;
            }
            for (SearchAndReplace searchAndReplace : this.npmPackageNameReplacers) {
                Matcher matcher = searchAndReplace.search.matcher(npmPackageName);
                if (!matcher.matches()) continue;
                npmPackageName = matcher.replaceAll(searchAndReplace.replace);
                break;
            }
        }
        return npmPackageName + (moduleName.isEmpty() ? "" : "/" + moduleName);
    }

    private String computeRelativeModulePath(File currentFile, File importedFile) {
        File currentDir = currentFile.getParentFile();
        String relativeModulePath = CompilerUtils.getRelativePath((File)currentDir, (File)importedFile, (boolean)false);
        if (!(relativeModulePath = relativeModulePath.replace(File.separatorChar, '/')).startsWith(".")) {
            relativeModulePath = "./" + relativeModulePath;
        }
        return relativeModulePath;
    }

    private String getRequireModulePath(IdeDeclaration declaration) {
        Annotation nativeAnnotation = declaration.getAnnotation("Native");
        if (nativeAnnotation != null && this.getNativeAnnotationRequireValue(nativeAnnotation) == null) {
            return null;
        }
        String qualifiedName = declaration.getExtNamespaceRelativeTargetQualifiedNameStr();
        if ("AS3.Error".equals(qualifiedName)) {
            return null;
        }
        return qualifiedName.replace('.', '/');
    }

    public static String getNonRequireNativeName(IdeDeclaration primaryDeclaration) {
        Annotation nativeAnnotation = primaryDeclaration.getAnnotation("Native");
        if (nativeAnnotation != null && TypeScriptModuleResolver.getAnnotationParameterValue(nativeAnnotation, "require", "") == null) {
            String nativeName = TypeScriptModuleResolver.getNativeAnnotationValue(nativeAnnotation);
            if (nativeName == null) {
                nativeName = primaryDeclaration.getQualifiedNameStr();
            }
            if (!"Ext.Base".equals(nativeName)) {
                return nativeName;
            }
        }
        return null;
    }

    @Override
    protected String getNativeAnnotationRequireValue(Annotation nativeAnnotation) {
        if ("Ext.Base".equals(TypeScriptModuleResolver.getNativeAnnotationValue(nativeAnnotation))) {
            return "";
        }
        return super.getNativeAnnotationRequireValue(nativeAnnotation);
    }

    public static String toLocalName(String[] qualifiedName) {
        return String.join((CharSequence)"_", qualifiedName);
    }
}

