/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.mxml.MxmlParserHelper;
import net.jangaroo.jooc.mxml.ast.ClassDeclarationBuilder;
import net.jangaroo.jooc.mxml.ast.CompilationUnitUtils;
import net.jangaroo.jooc.mxml.ast.IsInitMethod;
import net.jangaroo.jooc.mxml.ast.IsNativeConstructor;
import net.jangaroo.jooc.mxml.ast.MxmlAstUtils;
import net.jangaroo.jooc.mxml.ast.MxmlToModelParser;
import net.jangaroo.jooc.mxml.ast.RootElementProcessor;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlElement;
import net.jangaroo.jooc.mxml.ast.XmlHeader;
import net.jangaroo.utils.CompilerUtils;

public class MxmlCompilationUnit
extends CompilationUnit {
    public static final String NET_JANGAROO_EXT_EXML = "net.jangaroo.ext.Exml";
    static final String APPLY = "apply";
    private final RootElementProcessor rootElementProcessor = new RootElementProcessor();
    private final IsNativeConstructor isNativeConstructor = new IsNativeConstructor(this);
    private final IsInitMethod isInitMethod = new IsInitMethod();
    private final Collection<String> importedSymbols = new HashSet<String>();
    private final InputSource source;
    private final XmlHeader optXmlHeader;
    private final XmlElement rootNode;
    private final MxmlParserHelper mxmlParserHelper;
    private final List<Directive> constructorBodyDirectives = new LinkedList<Directive>();
    private final List<Directive> classBodyDirectives = new LinkedList<Directive>();
    private final String classQName;
    private FunctionDeclaration initMethod;
    private Parameter constructorParam;
    private MxmlToModelParser mxmlToModelParser;
    private final Map<String, VariableDeclaration> classVariablesByName = new LinkedHashMap<String, VariableDeclaration>();

    public MxmlCompilationUnit(@Nonnull InputSource source, @Nullable XmlHeader optXmlHeader, @Nonnull XmlElement rootNode, @Nonnull MxmlParserHelper mxmlParserHelper) {
        super(null, MxmlAstUtils.sym_lbrace(), new LinkedList<Directive>(), null, MxmlAstUtils.sym_rbrace(), Collections.emptyList());
        this.source = source;
        this.optXmlHeader = optXmlHeader;
        this.rootNode = rootNode;
        this.mxmlParserHelper = mxmlParserHelper;
        this.classQName = CompilerUtils.qNameFromRelativePath((String)source.getRelativePath());
    }

    @Override
    public void scope(Scope scope) {
        Expr superConfigExpr;
        Ide config;
        this.packageDeclaration = this.mxmlParserHelper.parsePackageDeclaration(this.classQName);
        JangarooParser parser2 = scope.getCompiler();
        this.mxmlToModelParser = new MxmlToModelParser(parser2, this.mxmlParserHelper, this);
        this.rootElementProcessor.process(this.rootNode);
        for (JooSymbol jooSymbol : this.rootElementProcessor.getImports()) {
            this.addImport(jooSymbol);
        }
        ClassDeclaration classDeclaration = new ClassDeclarationBuilder(parser2, this.mxmlParserHelper, this).build();
        this.primaryDeclaration = classDeclaration;
        Ide superClassIde = classDeclaration.getOptExtends().getSuperClass();
        this.addImport(superClassIde);
        Implements impl = classDeclaration.getOptImplements();
        if (null != impl) {
            Iterator<Directive> superTypes = impl.getSuperTypes();
            for (AstNode superType : ((CommaSeparatedList)((Object)superTypes)).getChildren()) {
                if (!(superType instanceof Ide)) continue;
                this.addImport((Ide)superType);
            }
        }
        for (JooSymbol jooSymbol : this.rootElementProcessor.getMetadata()) {
            List<Annotation> annotations = this.mxmlParserHelper.parseMetadata(jooSymbol);
            if (null == annotations) continue;
            this.primaryDeclaration.getAnnotations().addAll(annotations);
        }
        for (Directive directive : this.classBodyDirectives) {
            if (!(directive instanceof VariableDeclaration)) continue;
            VariableDeclaration variableDeclaration = (VariableDeclaration)directive;
            this.classVariablesByName.put(variableDeclaration.getName(), variableDeclaration);
            ((ClassDeclaration)this.primaryDeclaration).registerMember(variableDeclaration);
        }
        this.preProcessClassBodyDirectives();
        boolean useSuperConfig = CompilationUnitUtils.constructorSupportsConfigOptionsParameter(superClassIde.getQualifiedNameStr(), parser2);
        ObjectLiteral defaultsConfig = this.createFields(useSuperConfig);
        Ide ide = config = this.constructorParam == null ? null : this.constructorParam.getIde();
        if (defaultsConfig.getFields() != null) {
            if (config == null) {
                config = new Ide("config");
                MxmlAstUtils.createVariableDeclaration(config, classDeclaration.getIde(), defaultsConfig);
            } else {
                ApplyExpr applyOntoDefaultsExpr = this.createExmlApply(defaultsConfig, new IdeExpr(config));
                AssignmentOpExpr assignmentOpExpr = new AssignmentOpExpr(new IdeExpr(new Ide("config")), MxmlAstUtils.sym_eq().withWhitespace(" "), applyOntoDefaultsExpr);
                assignmentOpExpr.getSymbol().setWhitespace("\n    ");
                this.constructorBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(assignmentOpExpr));
            }
        }
        Expr configFromMxmlExpr = this.mxmlToModelParser.createExprFromElement(this.rootNode, true, true);
        if (useSuperConfig) {
            if (configFromMxmlExpr instanceof ApplyExpr) {
                configFromMxmlExpr = MxmlAstUtils.createApplyExpr(new IdeExpr(new Ide(classDeclaration.getName())), ((ApplyExpr)configFromMxmlExpr).getArgs().getExpr().getHead());
            }
            superConfigExpr = config == null ? configFromMxmlExpr : this.createExmlApply(configFromMxmlExpr, new IdeExpr(config));
            this.constructorBodyDirectives.add(MxmlAstUtils.createSuperConstructorCall(superConfigExpr));
        } else {
            Expr expr = MxmlCompilationUnit.isSuperConfigEmpty(configFromMxmlExpr) ? (config == null ? null : new IdeExpr(config)) : (superConfigExpr = config == null ? configFromMxmlExpr : this.createExmlApply(configFromMxmlExpr, new IdeExpr(config)));
            if (superConfigExpr != null) {
                this.constructorBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(this.createExmlApply(MxmlAstUtils.createThisExpr(), superConfigExpr)));
            }
        }
        this.classBodyDirectives.addAll(this.mxmlToModelParser.getClassBodyDirectives());
        this.postProcessClassBodyDirectives();
        super.scope(scope);
    }

    private static boolean isSuperConfigEmpty(Expr configFromMxmlExpr) {
        Expr superConfigObject = configFromMxmlExpr instanceof ApplyExpr ? ((ApplyExpr)configFromMxmlExpr).getArgs().getExpr().getHead() : configFromMxmlExpr;
        return superConfigObject instanceof ObjectLiteral && ((ObjectLiteral)superConfigObject).getFields() == null;
    }

    private ApplyExpr createExmlApply(Expr targetObject, Expr sourceObject) {
        return MxmlAstUtils.createApplyExpr(MxmlAstUtils.createDotExpr(this.addImport(NET_JANGAROO_EXT_EXML), APPLY), targetObject, sourceObject);
    }

    void preProcessClassBodyDirectives() {
        Directive directive;
        boolean hasNativeConstructor = false;
        for (int i = 0; i < this.classBodyDirectives.size(); ++i) {
            directive = this.classBodyDirectives.get(i);
            if (this.isNativeConstructor.apply(directive)) {
                hasNativeConstructor = true;
                FunctionDeclaration constructor = MxmlAstUtils.createConstructor((FunctionDeclaration)directive, this.constructorBodyDirectives);
                Parameters params = constructor.getParams();
                if (null != params) {
                    this.constructorParam = (Parameter)params.getHead();
                }
                this.classBodyDirectives.set(i, constructor);
                continue;
            }
            if (!this.isInitMethod.apply(directive)) continue;
            this.initMethod = (FunctionDeclaration)directive;
        }
        if (!hasNativeConstructor) {
            FunctionDeclaration constructor = MxmlAstUtils.createConstructor(this.primaryDeclaration.getIde(), this.constructorBodyDirectives);
            this.classBodyDirectives.add(constructor);
            this.constructorParam = (Parameter)constructor.getParams().getHead();
        }
        if (this.constructorParam != null) {
            Iterator<Directive> iterator = this.classBodyDirectives.iterator();
            while (iterator.hasNext()) {
                VariableDeclaration declaration;
                directive = iterator.next();
                if (!(directive instanceof VariableDeclaration) || !(declaration = (VariableDeclaration)directive).isPrivate() || declaration.isStatic() || !this.constructorParam.getName().equals(declaration.getName())) continue;
                iterator.remove();
                break;
            }
        }
        if (null != this.initMethod) {
            CommaSeparatedList<Expr> args = null;
            if (null != this.constructorParam && this.initMethod.getParams() != null) {
                args = new CommaSeparatedList<Expr>(new IdeExpr(this.constructorParam.getIde()));
            }
            DotExpr initFunctionInvocation = new DotExpr(MxmlAstUtils.createThisExpr(), MxmlAstUtils.sym_dot(), new Ide(this.initMethod.getIde().getSymbol().withoutWhitespace()));
            SemicolonTerminatedStatement directive2 = MxmlAstUtils.createSemicolonTerminatedStatement(new ApplyExpr(initFunctionInvocation, this.initMethod.getFun().getLParen(), args, this.initMethod.getFun().getRParen()));
            this.constructorBodyDirectives.add(directive2);
        }
    }

    void postProcessClassBodyDirectives() {
        for (Directive directive : this.classBodyDirectives) {
            directive.setClassMember(true);
        }
    }

    ObjectLiteral createFields(boolean useSuperConfig) {
        ArrayList<ObjectField> defaults = new ArrayList<ObjectField>();
        for (XmlElement declaration : this.rootElementProcessor.getDeclarations()) {
            Expr valueExpr;
            XmlAttribute fieldNameSym = declaration.getAttribute("id");
            if (fieldNameSym == null || (valueExpr = this.mxmlToModelParser.createExprFromElement(declaration, null, this.constructorParam != null && useSuperConfig)) == null) continue;
            if (valueExpr instanceof AssignmentOpExpr) {
                this.constructorBodyDirectives.add(MxmlAstUtils.createSemicolonTerminatedStatement(valueExpr));
                continue;
            }
            ObjectField objectField = MxmlAstUtils.createObjectField((String)fieldNameSym.getValue().getJooValue(), valueExpr);
            objectField.getSymbol().setWhitespace(valueExpr.getSymbol().getWhitespace());
            valueExpr.getSymbol().setWhitespace(" ");
            defaults.add(objectField);
        }
        ObjectLiteral defaultsObjectLiteral = MxmlAstUtils.createObjectLiteral(defaults);
        defaultsObjectLiteral.getRBrace().setWhitespace("\n    ");
        return defaultsObjectLiteral;
    }

    List<Directive> getClassBodyDirectives() {
        return this.classBodyDirectives;
    }

    @Override
    public String getQualifiedNameStr() {
        return this.classQName;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    XmlElement getRootNode() {
        return this.rootNode;
    }

    RootElementProcessor getRootElementProcessor() {
        return this.rootElementProcessor;
    }

    @Override
    public InputSource getInputSource() {
        return this.source;
    }

    private void addImport(Ide classIde) {
        if (this.isNotYetImported(classIde)) {
            ImportDirective directive = MxmlAstUtils.createImport(classIde);
            this.getDirectives().add(directive);
        }
    }

    private boolean isNotYetImported(Ide classIde) {
        Ide qualifier = classIde.getQualifier();
        return qualifier != null && !this.importedSymbols.contains(qualifier.getQualifiedNameStr() + ".*") && this.importedSymbols.add(classIde.getQualifiedNameStr());
    }

    void addImport(@Nonnull JooSymbol symbol) {
        ImportDirective directive;
        String jooValue = (String)symbol.getJooValue();
        if (!this.importedSymbols.contains(jooValue) && null != (directive = this.mxmlParserHelper.parseImport(symbol)) && this.isNotYetImported(directive.getIde())) {
            this.getDirectives().add(directive);
        }
    }

    @Nullable
    public Ide addImport(@Nonnull String classQName) {
        if (!classQName.contains(".")) {
            return new Ide(classQName);
        }
        ImportDirective importDirective = this.mxmlParserHelper.parseImport(classQName);
        if (importDirective == null) {
            return null;
        }
        Ide ide = importDirective.getIde();
        if (this.isNotYetImported(ide)) {
            this.getDirectives().add(importDirective);
        }
        return ide;
    }

    @Nonnull
    public Map<String, VariableDeclaration> getVariables() {
        return this.classVariablesByName;
    }

    @Nullable
    public String getConstructorParamName() {
        return null != this.constructorParam ? this.constructorParam.getName() : null;
    }
}

