/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitorBase;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectFieldOrSpread;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.jooc.types.FunctionSignature;
import net.jangaroo.utils.AS3Type;

public class TypeChecker
extends AstVisitorBase {
    static final String ASSIGNED_EXPRESSION_ERROR_MESSAGE = "Assigned expression type %s is not assignable to type %s";
    static final String VARIABLE_DECLARATION_ERROR_MESSAGE = "Initializer type %s is not assignable to variable type %s";
    static final String ARGUMENT_EXPRESSION_ERROR_MESSAGE = "Argument type %s is not assignable to parameter type %s";
    static final String RETURN_EXPRESSION_ERROR_MESSAGE = "Return value type %s is not assignable to return type %s";
    static final String OBJECT_FIELD_EXPRESSION_ERROR_MESSAGE = "Object literal field value of type %s is not assignable to property type %s";
    static final String ARRAY_ELEMENT_EXPRESSION_ERROR_MESSAGE = "Array literal element type %s is not assignable to array element type %s";
    private CompileLog log;

    TypeChecker(CompileLog log) {
        this.log = log;
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        Expr returnExpr = returnStatement.getOptExpr();
        if (returnExpr != null) {
            AstNode parentNode;
            for (parentNode = returnExpr.getParentNode(); parentNode != null && !(parentNode instanceof FunctionExpr); parentNode = parentNode.getParentNode()) {
            }
            if (parentNode == null) {
                return;
            }
            FunctionExpr functionExpr = (FunctionExpr)parentNode;
            ExpressionType type = functionExpr.getType();
            if (type != null) {
                this.validateTypes(returnExpr.getSymbol(), type.getTypeParameter(), returnExpr, RETURN_EXPRESSION_ERROR_MESSAGE);
            }
        }
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) {
        FunctionDeclaration superConstructor = superConstructorCallStatement.getClassDeclaration().getSuperTypeDeclaration().getConstructor();
        if (superConstructor != null && superConstructor.getFun().getType() instanceof FunctionSignature) {
            this.checkParameterTypes((FunctionSignature)superConstructor.getFun().getType(), superConstructorCallStatement.getSymbol(), superConstructorCallStatement.getArgs());
        }
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) {
        ExpressionType classToConstruct;
        ExpressionType type = applyExpr.getFun().getType();
        if (applyExpr.getFun() instanceof IdeExpr) {
            Scope scope = ((IdeExpr)applyExpr.getFun()).getIde().getScope();
            if (applyExpr.isTypeCast() && applyExpr.getArgs().getExpr() != null && applyExpr.getArgs().getExpr().getHead() instanceof ObjectLiteral) {
                ExpressionType typeToCast = applyExpr.getFun().getType().getTypeParameter();
                type = new FunctionSignature(scope.getClassDeclaration(AS3Type.FUNCTION.name), null, 1, false, Collections.singletonList(typeToCast), typeToCast);
            } else if (applyExpr.isTypeCheckObjectLiteralFunctionCall()) {
                ExpressionType typeToAssert = applyExpr.getArgs().getExpr().getHead().getType().getTypeParameter();
                type = new FunctionSignature(scope.getClassDeclaration(AS3Type.FUNCTION.name), null, 2, false, Arrays.asList(scope.getExpressionType(AS3Type.CLASS), typeToAssert), typeToAssert);
            }
        }
        if (type != null && applyExpr.getFun() instanceof NewExpr && (classToConstruct = type.getTypeParameter()) != null && classToConstruct.getDeclaration() instanceof ClassDeclaration) {
            FunctionDeclaration constructor = ((ClassDeclaration)classToConstruct.getDeclaration()).getConstructor();
            Scope scope = type.getDeclaration().getIde().getScope();
            type = scope.getFunctionSignature(null, constructor == null ? null : constructor.getParams(), classToConstruct);
        }
        if (type instanceof FunctionSignature) {
            this.checkParameterTypes((FunctionSignature)type, applyExpr.getSymbol(), applyExpr.getArgs());
        }
    }

    private void checkParameterTypes(FunctionSignature functionSignature, FilePosition parameterCountErrorSymbol, ParenthesizedExpr<CommaSeparatedList<Expr>> parameters) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        if (parameters != null) {
            for (CommaSeparatedList<Expr> argsCSL = parameters.getExpr(); argsCSL != null; argsCSL = argsCSL.getTail()) {
                args.add(argsCSL.getHead());
            }
        }
        int maxParameterCount = functionSignature.getParameterTypes().size();
        if (args.size() < functionSignature.getMinArgumentCount() || !functionSignature.hasRest() && args.size() > maxParameterCount) {
            this.log.error(parameterCountErrorSymbol, "Wrong number of arguments, must be " + functionSignature.getMinArgumentCount() + (functionSignature.hasRest() || maxParameterCount == functionSignature.getMinArgumentCount() ? "" : " to " + maxParameterCount) + ".");
        } else {
            List<ExpressionType> parameterTypes = functionSignature.getParameterTypes();
            for (int i = 0; i < Math.min(parameterTypes.size(), args.size()); ++i) {
                ExpressionType parameterType = parameterTypes.get(i);
                Expr arg = (Expr)args.get(i);
                this.validateTypes(arg.getSymbol(), parameterType, arg, ARGUMENT_EXPRESSION_ERROR_MESSAGE);
            }
        }
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) {
        long opSym = assignmentOpExpr.getOp().sym;
        if (opSym == 77L) {
            return;
        }
        if (opSym == 78L || opSym == 75L || opSym == 74L) {
            return;
        }
        ExpressionType expected = assignmentOpExpr.getArg1().getType();
        this.validateTypes(assignmentOpExpr.getArg2().getSymbol(), expected, assignmentOpExpr.getArg2(), ASSIGNED_EXPRESSION_ERROR_MESSAGE);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        if (variableDeclaration == null || variableDeclaration.getOptInitializer() == null) {
            return;
        }
        Expr actualExpression = variableDeclaration.getOptInitializer().getValue();
        ExpressionType expected = variableDeclaration.getIde().getScope().getExpressionType(variableDeclaration);
        this.validateTypes(actualExpression.getSymbol(), expected, actualExpression, VARIABLE_DECLARATION_ERROR_MESSAGE);
    }

    private void validateTypes(@Nonnull JooSymbol symbol, @Nullable ExpressionType expectedType, @Nonnull Expr actualExpression, String logMessage) {
        if (expectedType == null || actualExpression.getType() == null || AS3Type.ANY.equals((Object)expectedType.getAS3Type()) || AS3Type.BOOLEAN.equals((Object)expectedType.getAS3Type())) {
            return;
        }
        TypeDeclaration expectedTypeDeclaration = expectedType.getDeclaration();
        if (actualExpression instanceof ObjectLiteral && expectedType.getDeclaration() instanceof ClassDeclaration) {
            this.validateObjectLiteral((ClassDeclaration)expectedType.getDeclaration(), (ObjectLiteral)actualExpression);
            return;
        }
        if (!actualExpression.getType().isAssignableTo(expectedType)) {
            this.logException(symbol, expectedTypeDeclaration.getQualifiedNameStr(), actualExpression.getType().getDeclaration().getQualifiedNameStr(), logMessage);
        } else if (actualExpression instanceof ArrayLiteral && expectedType.isArrayLike()) {
            this.validateArrayLiteral(expectedType.getTypeParameter(), (ArrayLiteral)actualExpression);
        }
    }

    private void validateObjectLiteral(ClassDeclaration classDeclaration, ObjectLiteral objectLiteral) {
        if (classDeclaration.isObject()) {
            return;
        }
        for (CommaSeparatedList<ObjectFieldOrSpread> fields = objectLiteral.getFields(); fields != null; fields = fields.getTail()) {
            ObjectField field;
            AstNode fieldLabel;
            ObjectFieldOrSpread fieldOrSpread = fields.getHead();
            if (!(fieldOrSpread instanceof ObjectField) || !((fieldLabel = (field = (ObjectField)fieldOrSpread).getLabel()) instanceof Ide)) continue;
            String propertyName = ((Ide)fieldLabel).getName();
            IdeDeclaration propertyDeclaration = classDeclaration.resolvePropertyDeclaration(propertyName);
            if (propertyDeclaration != null) {
                ExpressionType type;
                if (propertyDeclaration instanceof PropertyDeclaration) {
                    propertyDeclaration = ((PropertyDeclaration)propertyDeclaration).getSetter();
                }
                if ((type = propertyDeclaration.getType()) != null) {
                    type = type.getEvalType();
                }
                if (type == null) {
                    type = propertyDeclaration.getIde().getScope().getExpressionType(propertyDeclaration);
                }
                this.validateTypes(field.getValue().getSymbol(), type, field.getValue(), OBJECT_FIELD_EXPRESSION_ERROR_MESSAGE);
                continue;
            }
            if (classDeclaration.isDynamic()) continue;
            this.log.warning((FilePosition)TypeChecker.getErrorSymbol(field), String.format("Property '%s' not found in type %s.", propertyName, classDeclaration.getQualifiedNameStr()));
        }
    }

    private void validateArrayLiteral(ExpressionType itemType, ArrayLiteral arrayLiteral) {
        if (itemType != null && !AS3Type.ANY.equals((Object)itemType.getAS3Type()) && !itemType.isObject()) {
            for (CommaSeparatedList arrayItems = (CommaSeparatedList)arrayLiteral.getExpr(); arrayItems != null; arrayItems = arrayItems.getTail()) {
                Expr arrayItem = (Expr)arrayItems.getHead();
                this.validateTypes(arrayItem.getSymbol(), itemType, arrayItem, ARRAY_ELEMENT_EXPRESSION_ERROR_MESSAGE);
            }
        }
    }

    private static JooSymbol getErrorSymbol(ObjectField field) {
        JooSymbol errorSymbol = field.getSymbol();
        if (errorSymbol.getFileName().isEmpty()) {
            errorSymbol = field.getValue().getSymbol();
        }
        return errorSymbol;
    }

    private void logException(JooSymbol jooSymbol, String expectedType, String actualType, String logMessage) {
        this.log.error((FilePosition)jooSymbol, String.format(logMessage, actualType, expectedType));
    }
}

