/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.types.FunctionSignature;

public class FunctionDeclaration
extends TypedIdeDeclaration {
    private FunctionExpr fun;
    private JooSymbol symGetOrSet;
    private JooSymbol optSymSemicolon;
    private boolean isConstructor = false;
    private boolean isDeclaredInInterface = false;
    private boolean containsSuperConstructorCall = false;
    private static final int DEFAULT_ALLOWED_METHOD_MODIFIERS = 3839;

    public FunctionDeclaration(AnnotationsAndModifiers am, JooSymbol symFunction, JooSymbol symGetOrSet, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, BlockStatement optBody, JooSymbol optSymSemicolon) {
        super(am, ide, optTypeRelation);
        this.fun = new FunctionExpr(this, symFunction, ide, lParen, params, rParen, optTypeRelation, optBody);
        this.symGetOrSet = symGetOrSet;
        this.optSymSemicolon = optSymSemicolon;
        if (this.isGetterOrSetter() && !this.isGetter() && !this.isSetter()) {
            throw JangarooParser.error(symGetOrSet, "Expected 'get' or 'set'.");
        }
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(this.getAnnotations(), this.fun);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitFunctionDeclaration(this);
    }

    @Override
    public int getModifiers() {
        int modifiers = super.getModifiers();
        if (this.isDeclaredInInterface) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public boolean overrides() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isMethod() {
        return this.isClassMember();
    }

    @Override
    public boolean isWritable() {
        return this.isSetter();
    }

    public boolean isGetterOrSetter() {
        return this.symGetOrSet != null;
    }

    public boolean isGetter() {
        return FunctionDeclaration.isGetter(this.symGetOrSet);
    }

    private static boolean isGetter(JooSymbol symGetOrSet) {
        return symGetOrSet != null && "get".equals(symGetOrSet.getText());
    }

    public boolean isSetter() {
        return FunctionDeclaration.isSetter(this.symGetOrSet);
    }

    private static boolean isSetter(JooSymbol symGetOrSet) {
        return symGetOrSet != null && "set".equals(symGetOrSet.getText());
    }

    public MethodType getMethodType() {
        return this.isSetter() ? MethodType.SET : (this.isGetter() ? MethodType.GET : null);
    }

    @Override
    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public FunctionExpr getFun() {
        return this.fun;
    }

    public JooSymbol getSymGetOrSet() {
        return this.symGetOrSet;
    }

    public JooSymbol getOptSymSemicolon() {
        return this.optSymSemicolon;
    }

    public boolean containsSuperConstructorCall() {
        return this.isContainsSuperConstructorCall();
    }

    public void setContainsSuperConstructorCall(boolean containsSuperConstructorCallStatement) {
        this.containsSuperConstructorCall = containsSuperConstructorCallStatement;
    }

    @Override
    public boolean isAbstract() {
        return this.getClassDeclaration() != null && this.getClassDeclaration().isInterface() || super.isAbstract();
    }

    public Parameters getParams() {
        return this.fun.getParams();
    }

    public boolean hasBody() {
        return this.fun.hasBody();
    }

    public BlockStatement getBody() {
        return this.fun.getBody();
    }

    @Override
    public void scope(Scope scope) {
        ClassDeclaration classDeclaration = scope.getClassDeclaration();
        Ide oldIde = this.getIde();
        if (classDeclaration != null && !this.isGetterOrSetter() && this.getIde().getName().equals(classDeclaration.getName())) {
            this.setConstructor(true);
            classDeclaration.setConstructor(this);
            this.setIde(null);
        }
        this.isDeclaredInInterface = classDeclaration != null && classDeclaration.isInterface();
        super.scope(scope);
        this.setIde(oldIde);
        if (this.overrides() && this.isAbstract()) {
            throw JangarooParser.error(this, "overriding methods are not allowed to be declared abstract");
        }
        if (this.isAbstract()) {
            if (classDeclaration == null) {
                throw JangarooParser.error(this, "package-scoped function " + this.getName() + " must not be abstract.");
            }
            if (!classDeclaration.isAbstract()) {
                throw JangarooParser.error(this, classDeclaration.getName() + "is not declared abstract");
            }
            if (this.hasBody()) {
                throw JangarooParser.error(this, "abstract method must not be implemented");
            }
        }
        if (this.isNative() && this.hasBody()) {
            throw JangarooParser.error(this, "native method must not be implemented");
        }
        if (!(this.isAbstract() || this.isNative() || this.hasBody())) {
            throw JangarooParser.error(this, "method must either be implemented or declared abstract or native");
        }
        if (!this.isStatic()) {
            ClassDeclaration currentClass = scope.getClassDeclaration();
            if (classDeclaration != null) {
                this.fun.setThisDefined();
                Type superType = currentClass.getSuperType();
                if (superType != null) {
                    this.fun.addImplicitParam(new Parameter(null, new Ide("super"), new TypeRelation(null, superType), null));
                }
            }
        }
        this.fun.scope(scope);
        if (this.containsSuperConstructorCall()) {
            BlockStatement block = this.getBody();
            block.checkSuperConstructorCall();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        this.analyzeSymModifiers();
        super.analyze(parentNode);
        this.fun.analyze(this);
        if (this.isOverride()) {
            IdeDeclaration superDeclaration = this.getClassDeclaration().getSuperTypeDeclaration().resolvePropertyDeclaration(this.getIde().getName(), this.isStatic());
            CompileLog log = this.getIde().getScope().getCompiler().getLog();
            if (superDeclaration instanceof PropertyDeclaration) {
                superDeclaration = ((PropertyDeclaration)superDeclaration).getAccessor(this.isSetter());
            }
            if (!(superDeclaration instanceof FunctionDeclaration)) {
                log.error((FilePosition)this.getFun().getSymbol(), "Method does not override method from super class");
            } else {
                FunctionSignature superMethodSignature;
                FunctionDeclaration superMethodDeclaration = (FunctionDeclaration)superDeclaration;
                FunctionSignature methodSignature = this.getMethodSignature();
                if (!methodSignature.equals(superMethodSignature = superMethodDeclaration.getMethodSignature())) {
                    log.error((FilePosition)this.getFun().getSymbol(), "Incompatible override, should have signature '" + superMethodSignature.toString() + "'");
                }
            }
        }
        if (this.isPublicApi()) {
            for (Parameters params = this.getParams(); params != null; params = params.getTail()) {
                Parameter parameter = (Parameter)params.getHead();
                if (this.isClassMember() && this.isPublicApi() && parameter.getOptInitializer() != null) {
                    parameter.getOptInitializer().addPublicApiDependencies();
                }
                this.addPublicApiDependencyOn(parameter.getOptTypeRelation());
            }
            this.addPublicApiDependencyOn(this.fun.getOptTypeRelation());
        }
    }

    public FunctionSignature getMethodSignature() {
        return (FunctionSignature)this.getType();
    }

    private void analyzeSymModifiers() {
        JooSymbol[] jooSymbolArray;
        int n;
        int n2;
        ClassDeclaration classDeclaration = this.getClassDeclaration();
        if (null != classDeclaration && classDeclaration.isInterface() && (n2 = 0) < (n = (jooSymbolArray = this.getSymModifiers()).length)) {
            JooSymbol symModifier = jooSymbolArray[n2];
            throw JangarooParser.error(symModifier, "illegal modifier: " + symModifier.getText());
        }
    }

    public boolean isThisAliased(boolean allowArrowFunctions) {
        return this.getFun().isThisAliased(allowArrowFunctions);
    }

    @Override
    protected boolean propagateInstanceThisUsed() {
        return !this.isClassMember();
    }

    @Override
    protected int getAllowedModifiers() {
        return this.isConstructor() ? 1551 : 3839;
    }

    @Override
    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        FunctionDeclaration other;
        if (this.isGetterOrSetter() && oldNode instanceof FunctionDeclaration && (other = (FunctionDeclaration)oldNode).isGetterOrSetter() && this.isGetter() != other.isGetter()) {
            return;
        }
        super.handleDuplicateDeclaration(scope, oldNode);
    }

    @Override
    public JooSymbol getDeclarationSymbol() {
        return this.getFun().getSymbol();
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this.isConstructor() ? this.getClassDeclaration() : super.resolveDeclaration();
    }

    public void setConstructor(boolean constructor) {
        this.isConstructor = constructor;
    }

    public boolean isContainsSuperConstructorCall() {
        return this.containsSuperConstructorCall;
    }

    @Override
    public boolean isExtConfig() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionDeclaration that = (FunctionDeclaration)o;
        return this.getIde().getName().equals(that.getIde().getName()) && (this.symGetOrSet == that.symGetOrSet || this.symGetOrSet != null && that.symGetOrSet != null && this.symGetOrSet.getText().equals(that.symGetOrSet.getText()));
    }

    public int hashCode() {
        int result = this.getIde().getName().hashCode();
        result = 31 * result + (this.symGetOrSet != null ? this.symGetOrSet.getText().hashCode() : 0);
        return result;
    }
}

