/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jangaroo.jooc.json.Json;
import net.jangaroo.jooc.json.JsonObject;

public class JsonArray
implements Json {
    private List<Object> items = new ArrayList<Object>();

    public JsonArray(Object ... items) {
        this.items = new ArrayList<Object>(Arrays.asList(items));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(JsonObject.valueToString(this.items.get(i), 0, -1));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toString(int indentFactor, int indent) {
        return this.toString(indentFactor, indent, false);
    }

    public String toString(int indentFactor, int indent, boolean alwaysQuoteKeys) {
        int len = this.items.size();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(JsonObject.valueToString(this.items.get(0), indentFactor, indent, alwaysQuoteKeys));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append(JsonObject.LINE_SEPARATOR);
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",").append(JsonObject.LINE_SEPARATOR);
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JsonObject.valueToString(this.items.get(i), indentFactor, newindent, alwaysQuoteKeys));
            }
            sb.append(JsonObject.LINE_SEPARATOR);
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public List<Object> getItems() {
        return new ArrayList<Object>(this.items);
    }

    @Override
    public Object get(String property) {
        return this.items.get(Integer.parseInt(property));
    }

    @Override
    public void set(String property, Object value) {
        this.items.set(Integer.parseInt(property), value);
    }
}

