/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.AbstractScope;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.utils.AS3Type;

public class DeclarationScope
extends AbstractScope {
    private final JangarooParser compiler;
    private AstNode definingNode;
    private Set<String> packages = new HashSet<String>();
    private Map<String, IdeDeclaration> ides = new HashMap<String, IdeDeclaration>();
    private Map<String, List<ImportDirective>> importsByName = new HashMap<String, List<ImportDirective>>();
    private Map<String, ImportDirective> importsByQualifiedName = new HashMap<String, ImportDirective>();
    private boolean isInstanceScope = false;

    @Override
    public boolean isPackage(String fullyQualifiedName) {
        return this.packages.contains(fullyQualifiedName) || super.isPackage(fullyQualifiedName);
    }

    public DeclarationScope(AstNode definingNode, Scope parent, JangarooParser compiler) {
        super(parent);
        this.definingNode = definingNode;
        this.compiler = compiler;
    }

    @Override
    public JangarooParser getCompiler() {
        return this.compiler;
    }

    @Override
    public AstNode getDefiningNode() {
        return this.definingNode;
    }

    @Override
    public void addImport(ImportDirective importDirective) {
        if (!(this.getDefiningNode() instanceof CompilationUnit)) {
            this.getParentScope().addImport(importDirective);
            return;
        }
        Ide ide = importDirective.getIde();
        String name = ide.getName();
        Ide packageIde = ide.getQualifier();
        String packageName = "";
        if (packageIde != null) {
            packageName = packageIde.getQualifiedNameStr();
            this.packages.add(packageName);
        }
        if (AS3Type.ANY.toString().equals(name)) {
            List<String> packageIdes = this.getCompiler().getPackageIdes(packageName);
            for (String typeToImport : packageIdes) {
                ImportDirective implicitImport = new ImportDirective(packageIde, typeToImport);
                implicitImport.scope(this);
            }
        } else {
            if (this.importsByName.containsKey(name)) {
                List<ImportDirective> directiveList = this.importsByName.get(name);
                if (this.isImportAlreadyAdded(directiveList, importDirective)) {
                    return;
                }
                directiveList.add(importDirective);
            } else {
                LinkedList<ImportDirective> list = new LinkedList<ImportDirective>();
                list.add(importDirective);
                this.importsByName.put(name, list);
            }
            if (this.ides.containsKey(name)) {
                throw new CompilerError(importDirective.getIde().getSymbol(), "attempt to redefine identifier " + name + " by import");
            }
            String qualifiedName = ide.getQualifiedNameStr();
            this.importsByQualifiedName.put(qualifiedName, importDirective);
        }
    }

    private boolean isImportAlreadyAdded(List<ImportDirective> directiveList, ImportDirective importDirective) {
        String qname = importDirective.getQualifiedName();
        for (ImportDirective directive : directiveList) {
            if (!directive.getQualifiedName().equals(qname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdeDeclaration declareIde(IdeDeclaration decl) {
        Ide ide = decl.getIde();
        String name = ide.getName();
        if (this.importsByName.containsKey(name)) {
            throw new CompilerError(ide.getSymbol(), "attempt to redefine an imported identifier " + name);
        }
        return this.ides.put(name, decl);
    }

    @Override
    public IdeDeclaration lookupDeclaration(Ide ide, boolean failOnAmbigousImport) {
        IdeDeclaration decl = null;
        if (ide instanceof QualifiedIde) {
            String qname = ide.getQualifiedNameStr();
            if (this.importsByQualifiedName.containsKey(qname)) {
                return this.resolveImport(this.importsByQualifiedName.get(qname));
            }
            if (ide.isQualifiedByThis()) {
                return this.getClassDeclaration().resolvePropertyDeclaration(ide.getName());
            }
            if (ide.isQualifiedBySuper()) {
                ClassDeclaration superTypeDeclaration = this.getClassDeclaration().getSuperTypeDeclaration();
                return superTypeDeclaration == null ? null : superTypeDeclaration.resolvePropertyDeclaration(ide.getName());
            }
        } else {
            String name = ide.getName();
            List<ImportDirective> importsOfThisIde = this.importsByName.get(name);
            if (importsOfThisIde != null) {
                if (failOnAmbigousImport && importsOfThisIde.size() > 1) {
                    this.ambigousImport(ide, importsOfThisIde);
                }
                try {
                    return this.resolveImport(importsOfThisIde.get(0));
                }
                catch (CompilerError e) {
                    this.getCompiler().getLog().error((FilePosition)ide.getIde(), e.getMessage());
                }
            }
            if ((decl = this.ides.get(ide.getName())) == null && this.getDefiningNode() != null && this.getClassDeclaration() == this.getDefiningNode()) {
                if (this.isInstanceScope) {
                    decl = this.getClassDeclaration().resolvePropertyDeclaration(ide.getName(), false);
                }
                if (decl == null) {
                    decl = this.getClassDeclaration().resolvePropertyDeclaration(ide.getName(), true);
                }
            }
        }
        return decl != null ? decl : super.lookupDeclaration(ide, failOnAmbigousImport);
    }

    private IdeDeclaration resolveImport(ImportDirective importDirective) {
        return this.getCompiler().resolveImport(importDirective);
    }

    private void ambigousImport(Ide ide, Collection<ImportDirective> importsOfThisIde) {
        boolean isFirst = true;
        StringBuilder msg = new StringBuilder();
        msg.append("Can not resolve a multiname reference unambiguously: ");
        for (ImportDirective importDirective : importsOfThisIde) {
            if (!isFirst) {
                msg.append(" and ");
            }
            isFirst = false;
            msg.append(importDirective.getQualifiedName());
            JooSymbol importedIdeSymbol = this.resolveImport(importDirective).getSymbol();
            msg.append("(").append(importedIdeSymbol.getFileName()).append(":").append(importedIdeSymbol.getLine()).append(",").append(importedIdeSymbol.getColumn());
        }
        msg.append(" are available.");
        throw new CompilerError(ide.getSymbol(), msg.toString());
    }

    @Override
    public boolean isDeclared(Ide ide) {
        return this.ides.containsKey(ide.getQualifiedNameStr()) || super.isDeclared(ide);
    }

    @Override
    public Ide findFreeAuxVar(String preferredName) {
        String auxVarNamePrefix = null != preferredName ? preferredName + "_$" : "$";
        int i = 1;
        String auxVarName;
        while (this.ides.containsKey(auxVarName = auxVarNamePrefix + i)) {
            ++i;
        }
        return new Ide(new JooSymbol(auxVarName));
    }

    @Override
    public Ide createAuxVar(String preferredName) {
        Ide auxVar = this.findFreeAuxVar(preferredName);
        new VariableDeclaration(null, auxVar, null).scope(this);
        return auxVar;
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        if (this.definingNode instanceof CompilationUnit) {
            return (CompilationUnit)this.definingNode;
        }
        return super.getCompilationUnit();
    }

    @Override
    public PackageDeclaration getPackageDeclaration() {
        if (this.definingNode instanceof PackageDeclaration) {
            return (PackageDeclaration)this.definingNode;
        }
        return super.getPackageDeclaration();
    }

    @Override
    public ClassDeclaration getClassDeclaration() {
        if (this.definingNode instanceof ClassDeclaration) {
            return (ClassDeclaration)this.definingNode;
        }
        return super.getClassDeclaration();
    }

    @Override
    public DeclarationScope getPackageDeclarationScope() {
        return this.definingNode instanceof PackageDeclaration ? this : super.getPackageDeclarationScope();
    }

    @Override
    public FunctionDeclaration getMethodDeclaration() {
        FunctionDeclaration functionDeclaration;
        if (this.definingNode instanceof FunctionDeclaration && (functionDeclaration = (FunctionDeclaration)this.definingNode).isClassMember()) {
            return functionDeclaration;
        }
        return super.getMethodDeclaration();
    }

    @Override
    public FunctionExpr getFunctionExpr() {
        if (this.definingNode instanceof FunctionExpr) {
            return (FunctionExpr)this.definingNode;
        }
        return super.getFunctionExpr();
    }

    public void setIsInstanceScope(boolean b) {
        this.isInstanceScope = true;
    }
}

