/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.backend.ModuleResolverBase;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;
import net.jangaroo.utils.CompilerUtils;

public class TypeScriptModuleResolver
extends ModuleResolverBase {
    public TypeScriptModuleResolver(CompilationUnitResolver compilationUnitModelResolver) {
        super(compilationUnitModelResolver);
    }

    public String getDefaultImportName(IdeDeclaration declaration) {
        String targetName;
        Annotation renameAnnotation = declaration.getAnnotation("Rename");
        if (renameAnnotation != null && (targetName = TypeScriptModuleResolver.getNativeAnnotationValue(renameAnnotation)) != null && !targetName.isEmpty()) {
            return CompilerUtils.className((String)targetName);
        }
        String nativeName = TypeScriptModuleResolver.getNonRequireNativeName(declaration);
        if (nativeName != null) {
            return nativeName;
        }
        return declaration.getName();
    }

    private boolean isGeneratedSource(File sourceDir) {
        return sourceDir.getPath().replace(File.separatorChar, '/').endsWith("generated-sources/joo");
    }

    private boolean isTestSource(File sourceDir) {
        return sourceDir.getPath().replace(File.separatorChar, '/').endsWith("test/joo");
    }

    public String getRequireModuleName(CompilationUnit compilationUnit, IdeDeclaration declaration) {
        String moduleName = this.getRequireModulePath(declaration);
        if (moduleName == null) {
            return null;
        }
        InputSource importedInputSource = declaration.getCompilationUnit().getInputSource();
        if (importedInputSource instanceof FileInputSource) {
            FileInputSource currentFileInputSource = (FileInputSource)compilationUnit.getInputSource();
            FileInputSource importedFileInputSource = (FileInputSource)importedInputSource;
            boolean isModule = this.getRequireModulePath(compilationUnit.getPrimaryDeclaration()) != null;
            File currentSourceDir = currentFileInputSource.getSourceDir();
            File importedSourceDir = importedFileInputSource.getSourceDir();
            String prefix = isModule && importedSourceDir.equals(currentSourceDir) || !isModule && !this.isGeneratedSource(importedSourceDir) && !this.isTestSource(importedSourceDir) || isModule && new File(currentSourceDir, importedInputSource.getRelativePath().replace("_properties.as", ".properties")).exists() ? "" : (this.isGeneratedSource(importedSourceDir) ? "../generated/src/" : "../src/");
            File currentDir = isModule ? CompilerUtils.fileFromQName((String)compilationUnit.getPrimaryDeclaration().getExtNamespaceRelativeTargetQualifiedNameStr(), (File)currentSourceDir, (String)".ts").getParentFile() : currentSourceDir;
            return this.computeRelativeModulePath(currentDir, new File(currentSourceDir, prefix + moduleName));
        }
        if (!(importedInputSource instanceof ZipEntryInputSource)) {
            throw new IllegalStateException("The input source for a compilation unit was not a file");
        }
        ZipFileInputSource inputSource = ((ZipEntryInputSource)importedInputSource).getZipFileInputSource();
        String npmPackageName = inputSource.getNpmPackageName();
        if (npmPackageName == null) {
            npmPackageName = inputSource.getSenchaPackageName();
        }
        if (npmPackageName == null) {
            return null;
        }
        if (npmPackageName.startsWith("net.jangaroo__")) {
            npmPackageName = npmPackageName.replace("net.jangaroo__", "@jangaroo/");
            if ((npmPackageName = npmPackageName.replace("/jangaroo-runtime", "/runtime")).endsWith("ext-as")) {
                npmPackageName = npmPackageName.replace("/ext-as", moduleName.startsWith("joo/") ? "" : "/ext-ts");
            }
        }
        return npmPackageName + (moduleName.isEmpty() ? "" : "/" + moduleName);
    }

    private String computeRelativeModulePath(File currentDir, File importedFile) {
        String relativeModulePath = currentDir.toPath().relativize(importedFile.toPath()).toString();
        if (!(relativeModulePath = relativeModulePath.replace(File.separatorChar, '/')).startsWith(".")) {
            relativeModulePath = "./" + relativeModulePath;
        }
        return relativeModulePath;
    }

    private String getRequireModulePath(IdeDeclaration declaration) {
        Annotation nativeAnnotation = declaration.getAnnotation("Native");
        if (nativeAnnotation != null && this.getNativeAnnotationRequireValue(nativeAnnotation) == null) {
            return null;
        }
        String qualifiedName = declaration.getExtNamespaceRelativeTargetQualifiedNameStr();
        if ("AS3.Error".equals(qualifiedName)) {
            return null;
        }
        return qualifiedName.replace('.', '/');
    }

    public static String getNonRequireNativeName(IdeDeclaration primaryDeclaration) {
        if ("Error".equals(primaryDeclaration.getQualifiedNameStr())) {
            return "Error";
        }
        Annotation nativeAnnotation = primaryDeclaration.getAnnotation("Native");
        if (nativeAnnotation != null && TypeScriptModuleResolver.getAnnotationParameterValue(nativeAnnotation, "require", "") == null) {
            String nativeName = TypeScriptModuleResolver.getNativeAnnotationValue(nativeAnnotation);
            if (nativeName == null) {
                nativeName = primaryDeclaration.getQualifiedNameStr();
            }
            if (!"Ext.Base".equals(nativeName)) {
                return nativeName;
            }
        }
        return null;
    }

    @Override
    protected String getNativeAnnotationRequireValue(Annotation nativeAnnotation) {
        if ("Ext.Base".equals(TypeScriptModuleResolver.getNativeAnnotationValue(nativeAnnotation))) {
            return "";
        }
        return super.getNativeAnnotationRequireValue(nativeAnnotation);
    }

    public static String toLocalName(String[] qualifiedName) {
        return String.join((CharSequence)"_", qualifiedName);
    }
}

