/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;

public class PathInputSource
extends DirectoryInputSource {
    private final String name;
    private final List<InputSource> entries;

    public static PathInputSource fromFiles(List<File> files, String[] rootDirs, boolean inSourcePath) throws IOException {
        return PathInputSource.fromFiles(files, rootDirs, inSourcePath, null);
    }

    public static PathInputSource createCompilePathAwareClassPath(List<File> classPath, String[] rootDirs, String extNamespace, List<File> compilePath) throws IOException {
        boolean inCompilePath = false;
        ArrayList<InputSource> entries = new ArrayList<InputSource>();
        StringBuilder name = new StringBuilder();
        for (File file : classPath) {
            boolean bl = inCompilePath = compilePath.isEmpty() || compilePath.contains(file);
            if (file.isDirectory()) {
                entries.add(new FileInputSource(file, file, false, inCompilePath, extNamespace));
            } else if (file.getName().endsWith(".swc") || file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                entries.add(new ZipFileInputSource(file, rootDirs, false, inCompilePath));
            }
            if (name.length() != 0) {
                name.append(File.pathSeparatorChar);
            }
            name.append(file.getAbsolutePath());
        }
        return new PathInputSource(name.toString(), entries, false, inCompilePath);
    }

    public static PathInputSource fromFiles(List<File> files, String[] rootDirs, boolean inSourcePath, String extNamespace) throws IOException {
        ArrayList<InputSource> entries = new ArrayList<InputSource>();
        StringBuilder name = new StringBuilder();
        for (File file : files) {
            if (file.isDirectory()) {
                entries.add(new FileInputSource(file, file, inSourcePath, extNamespace));
            } else if (file.getName().endsWith(".swc") || file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                entries.add(new ZipFileInputSource(file, rootDirs, inSourcePath));
            }
            if (name.length() != 0) {
                name.append(File.pathSeparatorChar);
            }
            name.append(file.getAbsolutePath());
        }
        return new PathInputSource(name.toString(), entries, inSourcePath);
    }

    public PathInputSource(String name, List<InputSource> entries, boolean inSourcePath, boolean inCompilePath) {
        super(inSourcePath, inCompilePath);
        this.name = name;
        this.entries = entries;
    }

    public PathInputSource(String name, List<InputSource> entries, boolean inSourcePath) {
        this(name, entries, inSourcePath, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    public List<InputSource> list() {
        ArrayList<InputSource> result = new ArrayList<InputSource>();
        for (InputSource entry : this.entries) {
            result.addAll(entry.list());
        }
        return result;
    }

    @Override
    public InputSource getChild(String path) {
        ArrayList<InputSource> result = null;
        for (InputSource entry : this.entries) {
            InputSource child = entry.getChild(path);
            if (child == null) continue;
            if (!child.isDirectory()) {
                return child;
            }
            if (result == null) {
                result = new ArrayList<InputSource>();
            }
            result.add(child);
        }
        return result == null ? null : new PathInputSource("(" + this.getName() + ")" + path, result, this.isInSourcePath());
    }

    @Override
    public List<InputSource> getChildren(String path) {
        ArrayList<InputSource> result = new ArrayList<InputSource>();
        for (InputSource entry : this.entries) {
            List<InputSource> children = entry.getChildren(path);
            result.addAll(children);
        }
        return result;
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathInputSource that = (PathInputSource)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

