/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.SyntacticKeywords;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.IsExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class Ide
extends NodeImplBase {
    private JooSymbol ide;
    private IdeDeclaration declaration;
    private Scope scope;
    private Ide qualified;
    private boolean bound;
    private boolean rewriteThis;
    private static final IdeDeclaration NULL_DECL = new VariableDeclaration(null, null, null, null);
    static /* synthetic */ Class class$net$jangaroo$jooc$ast$BinaryOpExpr;

    public Ide(String ide) {
        this(new JooSymbol(ide));
    }

    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIde(this);
    }

    public Ide(JooSymbol ide) {
        this.setIde(ide);
    }

    public Scope getScope() {
        return this.scope;
    }

    public JooSymbol getIde() {
        return this.ide;
    }

    private boolean isThis() {
        return "this".equals(this.getIde().getText());
    }

    private boolean needsThisAtRuntime() {
        if (this.isSuper()) {
            return true;
        }
        if (!this.isQualified() && this.isDeclared()) {
            IdeDeclaration decl = this.getDeclaration();
            return decl.isClassMember() && !decl.isStatic();
        }
        return false;
    }

    private boolean isSuper() {
        return "super".equals(this.getIde().getText());
    }

    public void scope(Scope scope) {
        if (this.scope == null) {
            this.scope = scope;
        }
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public String getQualifiedNameStr() {
        return this.getName();
    }

    public String getName() {
        return this.getIde().getText();
    }

    public JooSymbol getSymbol() {
        return this.getIde();
    }

    public boolean isQualifier() {
        return this.qualified != null;
    }

    public void setQualified(Ide qualifier) {
        this.qualified = qualifier;
    }

    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    public Ide getQualified() {
        return this.qualified;
    }

    public Ide getQualifier() {
        return null;
    }

    public boolean isQualifiedByThis() {
        return this.getQualifier() != null && this.getQualifier().isThis();
    }

    public boolean isQualifiedBySuper() {
        return this.getQualifier() != null && this.getQualifier().isSuper();
    }

    public boolean addExternalUsage() {
        IdeDeclaration decl = this.getDeclaration(false);
        if (decl == null || !decl.isPrimaryDeclaration()) {
            return false;
        }
        CompilationUnit currentUnit = this.getScope().getCompilationUnit();
        currentUnit.addDependency(decl.getIde().getScope().getCompilationUnit());
        return true;
    }

    public IdeDeclaration resolveDeclaration() {
        IdeDeclaration decl = this.getDeclaration(false);
        return decl == null ? null : decl.resolveDeclaration();
    }

    public IdeDeclaration getDeclaration() {
        return this.getDeclaration(true);
    }

    public IdeDeclaration getDeclaration(boolean errorIfUndeclared) {
        IdeDeclaration result;
        if (this.declaration == null) {
            this.declaration = this.getScope().lookupDeclaration(this);
            if (this.declaration == null) {
                this.declaration = NULL_DECL;
            } else if (this.declaration.getClassDeclaration() != this.getScope().getClassDeclaration()) {
                if (this.declaration.isPrivate()) {
                    throw new CompilerError(this.getSymbol(), "private member access");
                }
                if (this.declaration.isProtected() && !this.getScope().getClassDeclaration().isSubclassOf(this.declaration.getClassDeclaration())) {
                    throw new CompilerError(this.getSymbol(), "protected member access of non-superclass");
                }
            }
        }
        IdeDeclaration ideDeclaration = result = this.declaration == NULL_DECL ? null : this.declaration;
        if (result == null && errorIfUndeclared) {
            throw Jooc.error(this.getIde(), "undeclared identifier '" + this.getName() + "'");
        }
        return result;
    }

    public Ide qualify(JooSymbol symQualifier, JooSymbol symDot) {
        return new QualifiedIde(new Ide(symQualifier), symDot, this.getIde());
    }

    public void analyzeAsExpr(AstNode exprParent, Expr parentExpr) {
        IdeDeclaration memberDeclaration;
        FunctionExpr funExpr;
        if (this.needsThisAtRuntime() && (funExpr = this.scope.getFunctionExpr()) != null) {
            this.setRewriteThis(funExpr.notifyThisUsed(this.scope));
        }
        if (this.isSuper()) {
            FunctionDeclaration currentMethod = this.getScope().getMethodDeclaration();
            if (currentMethod == null) {
                throw Jooc.error(this.getIde(), "use of super is only allowed within non-static methods");
            }
            if (currentMethod.isStatic()) {
                throw Jooc.error(this.getIde(), "use of super inside static method");
            }
            FunctionExpr currentFunction = this.getScope().getFunctionExpr();
            if (currentFunction.getFunctionDeclaration() != currentMethod) {
                throw Jooc.error(this.getIde(), "super calls might only be used within instance methods, not in local functions");
            }
        }
        this.checkDefinedAccessChain();
        if (this.isBoundMethodCandidate(exprParent, parentExpr) && (memberDeclaration = this.getMemberDeclaration()) != null && memberDeclaration.isMethod() && !((FunctionDeclaration)memberDeclaration).isGetterOrSetter() && !memberDeclaration.isStatic()) {
            this.getScope().getClassDeclaration().addBuiltInUsage("$$bound");
            this.setBound(true);
        }
        if (this.scope != null) {
            this.usageInExpr(exprParent);
        }
    }

    public void usageInExpr(AstNode exprParent) {
        ClassDeclaration classDeclaration;
        FunctionDeclaration methodDeclaration;
        FunctionExpr funExpr;
        if (this.isThis() && (funExpr = this.getScope().getFunctionExpr()) != null && funExpr.getFunctionDeclaration() == null && (methodDeclaration = this.getScope().getMethodDeclaration()) != null && !methodDeclaration.isStatic()) {
            Jooc.warning(this.getSymbol(), "'this' may be unbound and is untyped in functions, even inside methods. Consider removing 'this.' (members are in scope!) or refactoring inner function to method.");
        }
        this.addExternalUsage();
        if (!(exprParent instanceof ApplyExpr || exprParent instanceof NewExpr || exprParent instanceof IsExpr || exprParent instanceof AsExpr || (classDeclaration = this.getScope().getClassDeclaration()) == null)) {
            if (this.isQualified()) {
                classDeclaration.addInitIfClass(this.getQualifier());
            }
            if (!this.isQualifier()) {
                classDeclaration.addInitIfClass(this);
            }
        }
    }

    public IdeDeclaration getMemberDeclaration() {
        IdeDeclaration declaration = this.getDeclaration(false);
        if (declaration != null && declaration.isClassMember()) {
            return declaration;
        }
        return declaration;
    }

    private void checkDefinedAccessChain() {
        if (!(this.isQualified() || this.isDeclared() || this.isValidPackageAccessChain())) {
            throw Jooc.error(this.getIde(), "undeclared identifier '" + this.getName() + "'");
        }
    }

    private boolean isValidPackageAccessChain() {
        if (this.isQualifier()) {
            Ide qualified = this.getQualified();
            return qualified.isDeclared() || qualified.isValidPackageAccessChain();
        }
        return false;
    }

    private boolean isDeclared() {
        return this.getDeclaration(false) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBoundMethodCandidate(AstNode exprParent, Expr parentExpr) {
        if (exprParent instanceof ParenthesizedExpr) return true;
        if (exprParent instanceof CommaSeparatedList) return true;
        if (exprParent instanceof Initializer) return true;
        if (exprParent instanceof AsExpr) return true;
        Class<?> clazz = exprParent.getClass();
        Class<?> clazz2 = class$net$jangaroo$jooc$ast$BinaryOpExpr;
        if (clazz2 == null) {
            clazz2 = class$net$jangaroo$jooc$ast$BinaryOpExpr = new BinaryOpExpr[0].getClass().getComponentType();
        }
        if (clazz.equals(clazz2)) return true;
        if (exprParent instanceof ObjectField) return true;
        if (exprParent instanceof ReturnStatement) return true;
        if (!(exprParent instanceof AssignmentOpExpr)) return false;
        if (((AssignmentOpExpr)exprParent).getArg2() != parentExpr) return false;
        return true;
    }

    public void generateCodeAsExpr(JsWriter out) throws IOException {
        IdeDeclaration decl;
        out.writeSymbolWhitespace(this.getIde());
        if (this.isSuper()) {
            this.writeThis(out);
            return;
        }
        if (!this.isThis() && (decl = this.getDeclaration(false)) != null) {
            String qname;
            if (decl.isClassMember()) {
                if (!decl.isPrivateStatic()) {
                    if (decl.isStatic()) {
                        out.writeToken(decl.getClassDeclaration().getQualifiedNameStr());
                    } else {
                        if (this.isBound()) {
                            this.writeBoundMethodAccess(out, null, null, decl);
                            return;
                        }
                        this.writeThis(out);
                    }
                }
                Ide.writeMemberAccess(decl, null, this, false, out);
                return;
            }
            if (!decl.isClassMember() && decl.getParentDeclaration() instanceof PackageDeclaration && !(qname = ((PackageDeclaration)decl.getParentDeclaration()).getQualifiedNameStr()).isEmpty()) {
                out.writeToken(qname);
                out.writeToken(".");
            }
        }
        this.writeIde(out);
    }

    public void writeIde(JsWriter out) throws IOException {
        if (SyntacticKeywords.RESERVED_WORDS.contains(this.getIde().getText())) {
            out.writeToken("$$" + this.getIde().getText());
        } else {
            out.writeSymbol(this.getIde(), false);
        }
    }

    private void writeThis(JsWriter out) throws IOException {
        out.writeToken(this.isRewriteThis() ? "this$" : "this");
    }

    protected void writeBoundMethodAccess(JsWriter out, Ide optIde, JooSymbol optSymDot, IdeDeclaration decl) throws IOException {
        out.writeToken("$$bound(");
        if (optIde != null) {
            optIde.generateCodeAsExpr(out);
        } else {
            this.writeThis(out);
        }
        if (optSymDot != null) {
            out.writeSymbolWhitespace(optSymDot);
        }
        out.writeToken(",");
        out.beginString();
        if (this.usePrivateMemberName(decl)) {
            out.writeToken(this.getName() + "$" + this.scope.getClassDeclaration().getInheritanceLevel());
        } else {
            out.writeToken(this.getName());
        }
        out.endString();
        out.writeToken(")");
    }

    public static void writeMemberAccess(IdeDeclaration memberDeclaration, JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace, JsWriter out) throws IOException {
        if (memberDeclaration != null && memberIde.usePrivateMemberName(memberDeclaration)) {
            Ide.writePrivateMemberAccess(optSymDot, memberIde, writeMemberWhitespace, memberDeclaration.isStatic(), out);
            return;
        }
        if (optSymDot == null && memberDeclaration != null && !memberDeclaration.isConstructor()) {
            optSymDot = new JooSymbol(".");
        }
        boolean quote = false;
        if (optSymDot != null) {
            if (memberIde.getIde().getText().startsWith("@")) {
                quote = true;
                out.writeSymbolWhitespace(optSymDot);
                out.writeToken("['");
            } else {
                out.writeSymbol(optSymDot);
            }
        }
        out.writeSymbol(memberIde.getIde(), writeMemberWhitespace);
        if (quote) {
            out.writeToken("']");
        }
    }

    private boolean usePrivateMemberName(IdeDeclaration memberDeclaration) {
        return this.isQualifiedBySuper() && this.scope.getClassDeclaration().getMemberDeclaration(this.getName()) != null || memberDeclaration.isPrivate();
    }

    public static IdeDeclaration resolveMember(IdeDeclaration type, Ide memberIde) {
        IdeDeclaration declaration = null;
        if (type != null) {
            declaration = type.resolvePropertyDeclaration(memberIde.getName());
        }
        return declaration;
    }

    static void writePrivateMemberAccess(JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace, boolean isStatic, JsWriter out) throws IOException {
        if (writeMemberWhitespace) {
            out.writeSymbolWhitespace(memberIde.getIde());
        }
        if (isStatic) {
            out.writeToken("$$private");
            if (optSymDot != null) {
                out.writeSymbol(optSymDot);
            } else {
                out.writeToken(".");
            }
            out.writeSymbol(memberIde.getIde(), false);
        } else {
            if (optSymDot != null) {
                out.writeSymbol(optSymDot);
            } else {
                out.writeToken(".");
            }
            out.writeToken(memberIde.getName() + "$" + memberIde.scope.getClassDeclaration().getInheritanceLevel());
        }
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ide ide1 = (Ide)o;
        return !(this.getIde() == null ? ide1.getIde() != null : !this.getIde().getText().equals(ide1.getIde().getText()));
    }

    public int hashCode() {
        int result = this.getIde() != null ? this.getIde().hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public void setIde(JooSymbol ide) {
        this.ide = ide;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isRewriteThis() {
        return this.rewriteThis;
    }

    public void setRewriteThis(boolean rewriteThis) {
        this.rewriteThis = rewriteThis;
    }
}

