/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.utils.CompilerUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLocations {
    private List<File> sourcePath = new ArrayList<File>();
    private List<File> sourceFiles = new ArrayList<File>();
    private List<File> classPath = new ArrayList<File>();
    private File outputDirectory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$config$FileLocations;

    public File findSourceDir(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        for (File sourceDir : this.getSourcePath()) {
            if (CompilerUtils.qNameFromFile(sourceDir, canonicalFile) == null) continue;
            return sourceDir;
        }
        return null;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<File> getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(List<File> sourcePath) throws IOException {
        ArrayList<File> canonicalizedSourcePath = new ArrayList<File>();
        for (File file : sourcePath) {
            canonicalizedSourcePath.add(file.getCanonicalFile());
        }
        this.sourcePath = Collections.unmodifiableList(canonicalizedSourcePath);
    }

    public List<File> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<File> classPath) {
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        this.classPath = Collections.unmodifiableList(classPath);
    }

    public List<File> getSourceFiles() {
        return Collections.unmodifiableList(this.sourceFiles);
    }

    public void setSourceFiles(List<File> sourceFiles) {
        if (sourceFiles == null) {
            throw new IllegalArgumentException("sourceFiles == null");
        }
        this.sourceFiles = new ArrayList<File>(sourceFiles);
    }

    public void addSourceFile(File source) {
        this.sourceFiles.add(source);
    }

    public void addSourceFile(String sourcepath) {
        this.addSourceFile(new File(sourcepath));
    }

    public String toString() {
        return new StringBuffer().append("FileLocations{sourcePath=").append(this.sourcePath).append(", sourceFiles=").append(this.sourceFiles).append(", classPath=").append(this.classPath).append(", outputDirectory=").append(this.outputDirectory).append('}').toString();
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$config$FileLocations;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$config$FileLocations = new FileLocations[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

