/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.jangaroo.properties.model.LocalizationSuite;
import net.jangaroo.properties.model.PropertiesClass;
import net.jangaroo.properties.model.ResourceBundleClass;
import net.jangaroo.utils.log.Log;
import org.codehaus.plexus.util.FileUtils;

public class PropertyClassGenerator {
    private static Configuration cfg = new Configuration();
    private static final String outputCharset = "UTF-8";
    private LocalizationSuite suite;

    public PropertyClassGenerator(LocalizationSuite suite) {
        this.suite = suite;
    }

    public void generatePropertiesClass(PropertiesClass propertiesClass, Writer out) throws IOException, TemplateException {
        Template template = cfg.getTemplate("properties_class.ftl");
        Environment env = template.createProcessingEnvironment((Object)propertiesClass, out);
        env.setOutputEncoding(outputCharset);
        env.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateJangarooClasses(ResourceBundleClass rbc) throws IOException, TemplateException {
        for (PropertiesClass pl : rbc.getPropertiesClasses()) {
            String rel = pl.getSrcFile().getPath().substring(this.suite.getRootDir().getPath().length());
            String convertedName = FileUtils.dirname((String)rel) + "/" + rbc.getClassName() + "_properties";
            if (pl.getLocale() != null) {
                convertedName = convertedName + "_" + pl.getLocale();
            }
            convertedName = convertedName + ".as";
            File outputFile = new File(this.suite.getOutputDir(), convertedName);
            if (!outputFile.getParentFile().exists() && outputFile.getParentFile().mkdirs()) {
                Log.e((String)"Could not create output folder");
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputCharset);
                this.generatePropertiesClass(pl, writer);
            }
            catch (IOException e) {
                Log.e((String)"error while generating class", (Exception)e);
            }
            catch (TemplateException e) {
                Log.e((String)"error while generating class", (Exception)((Object)e));
            }
            finally {
                try {
                    if (writer == null) continue;
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void generate() throws IOException, TemplateException {
        for (ResourceBundleClass rbc : this.suite.getResourceBundles()) {
            this.generateJangarooClasses(rbc);
        }
    }

    static {
        cfg.setClassForTemplateLoading(PropertyClassGenerator.class, "/net/jangaroo/properties/templates");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setOutputEncoding(outputCharset);
    }
}

