/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties.ant;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.jangaroo.properties.PropertiesFileScanner;
import net.jangaroo.properties.PropertyClassGenerator;
import net.jangaroo.properties.model.LocalizationSuite;
import net.jangaroo.utils.log.AntLogHandler;
import net.jangaroo.utils.log.Log;
import net.jangaroo.utils.log.LogHandler;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class PropcTask
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private File srcDir;
    private File destDir;
    private boolean failOnError = true;

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.compile();
    }

    protected void checkParameters() throws BuildException {
        if (this.srcDir == null || !this.srcDir.isDirectory()) {
            throw new BuildException("source directory \"" + this.srcDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
        if (this.destDir == null || !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        this.log("Compiling *.properties from " + this.srcDir + " to *.as " + (this.destDir != null ? " at " + this.destDir : ""));
        Log.setLogHandler((LogHandler)new AntLogHandler(this.getProject()));
        FileSet sourceFiles = new FileSet();
        sourceFiles.setDirectory(this.srcDir.getPath());
        sourceFiles.setIncludes(Collections.singletonList("**/*.properties"));
        LocalizationSuite suite = new LocalizationSuite(sourceFiles, this.destDir);
        PropertiesFileScanner scanner = new PropertiesFileScanner(suite);
        try {
            scanner.scan();
        }
        catch (IOException e) {
            throw new BuildException("Scan failure", (Throwable)e);
        }
        PropertyClassGenerator generator = new PropertyClassGenerator(suite);
        try {
            generator.generate();
        }
        catch (IOException e) {
            this.handleError(e);
        }
        catch (TemplateException e) {
            this.handleError((Exception)((Object)e));
        }
    }

    private void handleError(Exception e) {
        if (this.failOnError) {
            throw new BuildException(FAIL_MSG, (Throwable)e, this.getLocation());
        }
        this.log(FAIL_MSG, 0);
    }
}

