/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.jangaroo.properties.model.Property;
import net.jangaroo.properties.model.ResourceBundleClass;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;

public class PropertiesClass {
    private ResourceBundleClass resourceBundle;
    private Locale locale;
    private PropertiesConfiguration properties;
    private File srcFile;

    public PropertiesClass(ResourceBundleClass resourceBundle, Locale locale, PropertiesConfiguration properties, File srcFile) {
        this.resourceBundle = resourceBundle;
        resourceBundle.addLocaleProperties(locale, this);
        this.locale = locale;
        this.properties = properties;
        this.srcFile = srcFile;
    }

    public ResourceBundleClass getResourceBundle() {
        return this.resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getComment() {
        return this.adjustComment(this.properties.getLayout().getCanonicalHeaderComment(true));
    }

    public List<Property> getProps() {
        PropertiesConfigurationLayout layout = this.properties.getLayout();
        ArrayList<Property> props = new ArrayList<Property>();
        Iterator keys = this.properties.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            props.add(new Property(this.adjustComment(layout.getCanonicalComment(key, true)), key, this.properties.getString(key)));
        }
        return props;
    }

    private String adjustComment(String canonicalComment) {
        return canonicalComment == null ? null : canonicalComment.replaceAll("(^|\\n)#", "\n *");
    }

    public File getSrcFile() {
        return this.srcFile;
    }
}

