/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml;

import java.io.File;

public final class ExmlcException
extends RuntimeException {
    private File source;
    private int line;
    private int column;

    public ExmlcException(String message) {
        super(message);
    }

    public ExmlcException(String message, int line) {
        this(message, line, -1);
    }

    public ExmlcException(String message, int line, int column) {
        super(message);
        this.setLine(line);
        this.setColumn(column);
    }

    public ExmlcException(String message, Throwable t) {
        super(message, t);
    }

    public ExmlcException(String message, File source, Exception e) {
        this(message, e);
        this.setSource(source);
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public File getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.source != null) {
            builder.append('[');
            builder.append(this.source.toString());
            if (this.line > 0) {
                builder.append(":");
                builder.append(this.line);
                if (this.column != -1) {
                    builder.append(";");
                    builder.append(this.column);
                }
            }
            builder.append("] ");
        }
        builder.append(super.toString());
        return builder.toString();
    }
}

