/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.exml.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.utils.log.AntLogHandler;
import net.jangaroo.utils.log.Log;
import net.jangaroo.utils.log.LogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class ExmlcTask
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private String targetNamespace;
    private String namespacePrefix;
    private File xsdOutputFile;
    private Path src;
    private File destDir;
    private List<Path> importedXsds = new ArrayList<Path>();
    private boolean verbose = false;
    private boolean failOnError = true;

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public void setXsdOutputFile(File xsdOutputFile) {
        this.xsdOutputFile = xsdOutputFile;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addImportedXsds(Path importedXsdFile) {
        this.importedXsds.add(importedXsdFile);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.compile();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        this.log("Compiling *.exml from " + this.src + " to *.as " + (this.destDir != null ? " at " + this.destDir : ""));
        String[] exmlcArgs = this.getExmlcArgs();
        Log.setLogHandler((LogHandler)new AntLogHandler(this.getProject()));
        this.log("configured AntCompileLog");
        if (this.verbose) {
            StringBuilder cmdLine = new StringBuilder(100);
            cmdLine.append("exmlc ");
            for (String exmlcArg : exmlcArgs) {
                cmdLine.append(" ");
                cmdLine.append(exmlcArg);
            }
            this.getProject().log(cmdLine.toString());
        }
        ExmlConfiguration config = new ExmlConfiguration();
        try {
            new Exmlc(config).generateAllConfigClasses();
        }
        catch (ExmlcException e) {
            if (this.failOnError) {
                this.log(e.getMessage(), 0);
                throw new BuildException(FAIL_MSG, (Throwable)e, this.getLocation());
            }
            e.printStackTrace();
            this.log("Compile failed; see the compiler error output for details. Exception: " + e, 0);
        }
    }

    protected String[] getExmlcArgs() {
        ArrayList<String> args = new ArrayList<String>();
        Project project = this.getProject();
        String targetNamespaceArg = this.targetNamespace == null ? project.getName() : this.targetNamespace;
        args.add(targetNamespaceArg);
        String namespacePrefixArg = this.namespacePrefix == null ? project.getName() : this.namespacePrefix;
        args.add(namespacePrefixArg);
        args.add(this.xsdOutputFile.getAbsolutePath());
        args.add(this.src.toString());
        String destDirArg = this.destDir == null ? "." : this.destDir.getAbsolutePath();
        args.add(destDirArg);
        for (Path importedXsd : this.importedXsds) {
            Collections.addAll(args, importedXsd.list());
        }
        return args.toArray(new String[args.size()]);
    }
}

