/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.json;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.json.Json;
import net.jangaroo.exml.json.JsonArray;

public class JsonObject
implements Json {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String wrapperClass;

    public JsonObject(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("argument vector must be of even length, but is " + Arrays.asList(namesAndValues));
        }
        for (int i = 0; i < namesAndValues.length; i += 2) {
            Object name = namesAndValues[i];
            if (!(name instanceof String)) {
                throw new IllegalArgumentException("property names must be strings, found '" + name + "'");
            }
            Object value = namesAndValues[i + 1];
            this.properties.put((String)name, value);
        }
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public JsonObject settingWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
        return this;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static String valueToString(String key, Object value, int indentFactor, int indent) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)value;
            return jsonObject.toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
            return ((String)value).substring(1, ((String)value).lastIndexOf("}"));
        }
        return JsonObject.quote(value.toString());
    }

    @Override
    public String toString(int indentFactor, int indent) {
        Set<String> keySet = this.properties.keySet();
        StringBuilder sb = new StringBuilder();
        if (this.wrapperClass != null) {
            sb.append("new ").append(this.wrapperClass).append('(');
        }
        sb.append("{");
        int newindent = indent + indentFactor;
        int n = keySet.size();
        Iterator<String> keys = keySet.iterator();
        if (n == 1) {
            this.writeKeyValue(keys.next(), indentFactor, indent, sb);
        } else if (n > 1) {
            boolean isFirstAttribute = true;
            while (keys.hasNext()) {
                if (isFirstAttribute) {
                    isFirstAttribute = false;
                } else {
                    sb.append(",");
                }
                this.newlineAndIndent(sb, newindent);
                this.writeKeyValue(keys.next(), indentFactor, newindent, sb);
            }
            if (sb.length() > 1) {
                this.newlineAndIndent(sb, indent);
            }
        }
        sb.append('}');
        if (this.wrapperClass != null) {
            sb.append(')');
        }
        return sb.toString();
    }

    private void newlineAndIndent(StringBuilder sb, int indent) {
        sb.append(LINE_SEPARATOR);
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    private void writeKeyValue(String key, int indentFactor, int indent, StringBuilder sb) {
        sb.append(key);
        sb.append(": ");
        sb.append(JsonObject.valueToString(key, this.properties.get(key), indentFactor, indent));
    }

    @Override
    public Object get(String property) {
        return this.properties.get(property);
    }

    @Override
    public void set(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object remove(String property) {
        return this.properties.remove(property);
    }
}

