/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.ExmlcException;
import net.jangaroo.exml.as.ConfigClassBuilder;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.jooc.CompileLog;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.utils.CompilerUtils;

public final class ConfigClassRegistry {
    private Map<String, ConfigClass> configClassesByName = new HashMap<String, ConfigClass>();
    private Set<File> scannedExmlFiles = new HashSet<File>();
    private ExmlConfiguration config;
    private InputSource sourcePathInputSource;
    private JangarooParser jangarooParser;
    private ExmlToConfigClassParser exmlToConfigClassParser;

    public ConfigClassRegistry(final ExmlConfiguration config) throws IOException {
        this.config = config;
        this.sourcePathInputSource = PathInputSource.fromFiles((List)config.getSourcePath(), (String[])new String[0]);
        PathInputSource classPathInputSource = PathInputSource.fromFiles((List)config.getClassPath(), (String[])new String[]{"", "META-INF/joo-api/"});
        CCRParserOptions parserOptions = new CCRParserOptions();
        this.jangarooParser = new JangarooParser(parserOptions, (CompileLog)new StdOutCompileLog()){

            protected InputSource findSource(String qname) {
                InputSource inputSource = super.findSource(qname);
                if (inputSource instanceof FileInputSource && !((FileInputSource)inputSource).getSourceDir().equals(config.getOutputDirectory())) {
                    return inputSource;
                }
                ConfigClassRegistry.this.tryBuildConfigClassFromExml(qname);
                return super.findSource(qname);
            }
        };
        ArrayList<File> fullSourcePath = new ArrayList<File>(config.getSourcePath());
        fullSourcePath.add(config.getOutputDirectory());
        this.jangarooParser.setUp((InputSource)PathInputSource.fromFiles(fullSourcePath, (String[])new String[0]), (InputSource)classPathInputSource);
        this.exmlToConfigClassParser = new ExmlToConfigClassParser(config);
    }

    public ExmlConfiguration getConfig() {
        return this.config;
    }

    public Collection<ConfigClass> getRegisteredConfigClasses() {
        return this.configClassesByName.values();
    }

    public void scanAllAsFiles() {
        InputSource configPackage = this.sourcePathInputSource.getChild(this.config.getConfigClassPackage().replace('.', File.separatorChar));
        if (configPackage != null) {
            this.scanAsFiles(configPackage);
        }
    }

    private void scanAsFiles(InputSource inputSource) {
        for (InputSource source : inputSource.list()) {
            File file = ((FileInputSource)source).getFile();
            if (file.isFile()) {
                String qName;
                if (!file.getName().endsWith(".as")) continue;
                try {
                    qName = CompilerUtils.qNameFromFile((File)this.getConfig().findSourceDir(file), (File)file);
                }
                catch (IOException e) {
                    throw new ExmlcException("could not read AS file", e);
                }
                ConfigClass configClass = this.findActionScriptConfigClass(qName);
                this.addConfigClass(configClass);
                continue;
            }
            this.scanAsFiles(source);
        }
    }

    public void scanAllExmlFiles() {
        this.scanExmlFiles(this.sourcePathInputSource);
    }

    private void scanExmlFiles(InputSource inputSource) {
        for (InputSource source : inputSource.list()) {
            File exmlFile = ((FileInputSource)source).getFile();
            if (exmlFile.isFile()) {
                if (!exmlFile.getName().endsWith(".exml") || this.scannedExmlFiles.contains(exmlFile)) continue;
                this.scannedExmlFiles.add(exmlFile);
                try {
                    ConfigClass configClass = this.exmlToConfigClassParser.parseExmlToConfigClass(exmlFile);
                    this.addConfigClass(configClass);
                    continue;
                }
                catch (IOException e) {
                    throw new ExmlcException("could not read EXML file", e);
                }
            }
            this.scanExmlFiles(source);
        }
    }

    public ConfigClass getConfigClassByName(String name) {
        ConfigClass configClass = this.configClassesByName.get(name);
        if (configClass != null) {
            return configClass;
        }
        this.tryBuildConfigClassFromExml(name);
        configClass = this.configClassesByName.get(name);
        if (configClass != null) {
            return configClass;
        }
        configClass = this.findActionScriptConfigClass(name);
        this.addConfigClass(configClass);
        return configClass;
    }

    private void addConfigClass(ConfigClass configClass) {
        if (configClass != null) {
            String name = configClass.getFullName();
            ConfigClass existingConfigClass = this.configClassesByName.get(name);
            if (existingConfigClass != null) {
                if (!existingConfigClass.equals(configClass)) {
                    throw new ExmlcException("config class " + name + " declared in " + configClass.getComponentClassName() + " and " + existingConfigClass.getComponentClassName());
                }
            } else {
                this.configClassesByName.put(name, configClass);
            }
        }
    }

    private void tryBuildConfigClassFromExml(String name) {
        if (name.startsWith(this.config.getConfigClassPackage() + ".")) {
            String componentName;
            FileInputSource exmlInputSource;
            CompilationUnit compilationUnit;
            ConfigClass generatedAsConfigClass;
            FileInputSource outputDirInputSource = new FileInputSource(this.config.getOutputDirectory(), this.config.getOutputDirectory());
            FileInputSource generatedConfigAsFile = outputDirInputSource.getChild(JangarooParser.getInputSourceFileName((String)name, (InputSource)outputDirInputSource, (String)".as"));
            if (generatedConfigAsFile != null && (generatedAsConfigClass = this.buildConfigClass(compilationUnit = Jooc.doParse((InputSource)generatedConfigAsFile, (CompileLog)new StdOutCompileLog(), (SemicolonInsertionMode)SemicolonInsertionMode.QUIRKS))) != null && (exmlInputSource = (FileInputSource)this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName((String)(componentName = generatedAsConfigClass.getComponentClassName()), (InputSource)this.sourcePathInputSource, (String)".exml"))) != null) {
                ConfigClass configClass;
                this.scannedExmlFiles.add(exmlInputSource.getFile());
                try {
                    configClass = new ExmlToConfigClassParser(this.config).parseExmlToConfigClass(exmlInputSource.getFile());
                    this.evaluateSuperClass(configClass);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.addConfigClass(configClass);
                return;
            }
            this.scanAllExmlFiles();
        }
    }

    private ConfigClass findActionScriptConfigClass(String name) {
        CompilationUnit compilationsUnit = this.jangarooParser.getCompilationsUnit(name);
        ConfigClass configClass = null;
        if (compilationsUnit != null) {
            try {
                configClass = this.buildConfigClass(compilationsUnit);
                this.evaluateSuperClass(configClass);
            }
            catch (RuntimeException e) {
                throw new ExmlcException("while building config class '" + name + "': " + e.getMessage(), e);
            }
        }
        return configClass;
    }

    private void evaluateSuperClass(ConfigClass configClass) {
        if (configClass != null && configClass.getSuperClassName() != null && !"joo.JavaScriptObject".equals(configClass.getSuperClassName())) {
            ConfigClass superClass = this.findActionScriptConfigClass(configClass.getSuperClassName());
            if (superClass == null) {
                throw new ExmlcException(String.format("Superclass '%s' of class '%s' not found!", configClass.getSuperClassName(), configClass.getFullName()));
            }
            configClass.setSuperClass(superClass);
            this.evaluateSuperClass(superClass);
        }
    }

    private ConfigClass buildConfigClass(CompilationUnit compilationUnit) {
        ConfigClassBuilder configClassBuilder = new ConfigClassBuilder(compilationUnit);
        return configClassBuilder.buildConfigClass();
    }

    private static class CCRParserOptions
    implements ParserOptions {
        private CCRParserOptions() {
        }

        public SemicolonInsertionMode getSemicolonInsertionMode() {
            return SemicolonInsertionMode.QUIRKS;
        }

        public boolean isVerbose() {
            return false;
        }
    }
}

