/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jangaroo.exml.ExmlcException;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.parser.ExmlMetadataHandler;
import net.jangaroo.jooc.config.FileLocations;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExmlToConfigClassParser {
    private ExmlConfiguration config;

    public ExmlToConfigClassParser(ExmlConfiguration config) {
        this.config = config;
    }

    public ConfigClass parseExmlToConfigClass(File source) throws IOException {
        String fullQualifiedName = ExmlToConfigClassParser.computeComponentFullQualifiedName(this.config, source);
        ConfigClass configClass = new ConfigClass();
        configClass.setComponentClassName(fullQualifiedName);
        configClass.setPackageName(this.config.getConfigClassPackage());
        configClass.setName(ConfigClass.createNewName(FilenameUtils.getBaseName((String)source.getName())));
        configClass.setType(ConfigClassType.XTYPE);
        ExmlMetadataHandler metadataHandler = new ExmlMetadataHandler(configClass);
        ExmlToConfigClassParser.parseFileWithHandler(source, (ContentHandler)((Object)metadataHandler));
        return configClass;
    }

    private static void parseFileWithHandler(File source, ContentHandler handler) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(source);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            xr.parse(new InputSource(inputStream));
        }
        catch (ExmlcException e) {
            e.setSource(source);
            throw e;
        }
        catch (Exception e) {
            throw new ExmlcException("could not parse EXML file", source, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static String computeComponentFullQualifiedName(FileLocations locations, File sourceFile) throws IOException {
        File sourceDir = locations.findSourceDir(sourceFile);
        int rootDirPathLength = sourceDir.getPath().length() + 1;
        String subpath = FilenameUtils.removeExtension((String)sourceFile.getPath().substring(rootDirPathLength));
        return subpath.replaceAll("\\" + File.separator, "\\.");
    }
}

