/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.jangaroo.properties.PropcException;
import net.jangaroo.properties.model.PropertiesClass;
import net.jangaroo.properties.model.ResourceBundleClass;
import net.jangaroo.utils.CompilerUtils;
import net.jangaroo.utils.FileLocations;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PropertyClassGenerator {
    private static Configuration cfg = new Configuration();
    private static final String OUTPUT_CHARSET = "UTF-8";
    private FileLocations locations;

    public PropertyClassGenerator(FileLocations locations) {
        this.locations = locations;
    }

    public void generatePropertiesClass(PropertiesClass propertiesClass, Writer out) throws IOException, TemplateException {
        Template template = cfg.getTemplate("properties_class.ftl");
        Environment env = template.createProcessingEnvironment(propertiesClass, out);
        env.setOutputEncoding(OUTPUT_CHARSET);
        env.process();
    }

    public File generateJangarooClass(PropertiesClass pl) {
        File sourceDir;
        try {
            sourceDir = this.locations.findSourceDir(pl.getSrcFile());
        }
        catch (IOException e) {
            throw new PropcException(e);
        }
        String rel = pl.getSrcFile().getPath().substring(sourceDir.getPath().length());
        String convertedName = CompilerUtils.dirname(rel) + "/" + pl.getResourceBundle().getClassName() + "_properties";
        if (pl.getLocale() != null) {
            convertedName = convertedName + "_" + pl.getLocale();
        }
        convertedName = convertedName + ".as";
        File outputFile = new File(this.locations.getOutputDirectory(), convertedName);
        outputFile.getParentFile().mkdirs();
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), OUTPUT_CHARSET);
            this.generatePropertiesClass(pl, writer);
        }
        catch (Exception e) {
            throw new PropcException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        return outputFile;
    }

    public Map<File, Set<File>> generate() {
        LinkedHashMap<File, Set<File>> outputFileMap = new LinkedHashMap<File, Set<File>>();
        for (File srcFile : this.locations.getSourceFiles()) {
            Locale locale;
            String className;
            try {
                className = CompilerUtils.qNameFromFile(this.locations.findSourceDir(srcFile), srcFile);
            }
            catch (IOException e) {
                throw new PropcException(e);
            }
            if (className.indexOf(95) != -1) {
                String localeString = className.substring(className.indexOf(95) + 1, className.length());
                if (localeString.indexOf(95) != -1) {
                    String lang = localeString.substring(0, localeString.indexOf(95));
                    String countr = localeString.substring(lang.length() + 1, localeString.length());
                    if (countr.indexOf(95) != -1) {
                        String var = countr.substring(countr.indexOf(95) + 1, countr.length());
                        countr = countr.substring(0, countr.indexOf(95));
                        locale = new Locale(lang, countr, var);
                    } else {
                        locale = new Locale(lang, countr);
                    }
                } else {
                    locale = new Locale(localeString);
                }
                className = className.substring(0, className.indexOf(95));
            } else {
                locale = null;
            }
            ResourceBundleClass bundle = new ResourceBundleClass(className);
            PropertiesConfiguration p = new PropertiesConfiguration();
            p.setDelimiterParsingDisabled(true);
            Reader r = null;
            try {
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), OUTPUT_CHARSET));
                p.load(r);
            }
            catch (IOException e) {
                throw new PropcException("Error while parsing properties file", srcFile, e);
            }
            catch (ConfigurationException e) {
                throw new PropcException("Error while parsing properties file", srcFile, e);
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException e) {}
            }
            File outputFile = this.generateJangarooClass(new PropertiesClass(bundle, locale, p, srcFile));
            outputFileMap.put(srcFile, Collections.singleton(outputFile));
        }
        return outputFileMap;
    }

    static {
        cfg.setClassForTemplateLoading(PropertyClassGenerator.class, "/net/jangaroo/properties/templates");
        cfg.setObjectWrapper(new DefaultObjectWrapper());
        cfg.setOutputEncoding(OUTPUT_CHARSET);
    }
}

