/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ParentheticalExpression;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

class DefaultToExpression
extends Expression {
    private static final TemplateCollectionModel EMPTY_COLLECTION = new SimpleCollection(new ArrayList(0));
    static final TemplateModel EMPTY_STRING_AND_SEQUENCE = new EmptyStringAndSequence();
    private Expression lhs;
    private Expression rhs;

    DefaultToExpression(Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel left;
        block4: {
            left = null;
            try {
                left = this.lhs.getAsTemplateModel(env);
            }
            catch (InvalidReferenceException ire) {
                if (this.lhs instanceof ParentheticalExpression) break block4;
                throw ire;
            }
        }
        if (left != null) {
            return left;
        }
        if (this.rhs == null) {
            return EMPTY_STRING_AND_SEQUENCE;
        }
        return this.rhs.getAsTemplateModel(env);
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        if (this.rhs == null) {
            return new DefaultToExpression(this.lhs.deepClone(name, subst), null);
        }
        return new DefaultToExpression(this.lhs.deepClone(name, subst), this.rhs.deepClone(name, subst));
    }

    public String getCanonicalForm() {
        if (this.rhs == null) {
            return this.lhs.getCanonicalForm() + "!";
        }
        return this.lhs.getCanonicalForm() + "!" + this.rhs.getCanonicalForm();
    }

    private static class EmptyStringAndSequence
    implements TemplateScalarModel,
    TemplateSequenceModel,
    TemplateHashModelEx {
        private EmptyStringAndSequence() {
        }

        public String getAsString() {
            return "";
        }

        public TemplateModel get(int i) {
            return null;
        }

        public TemplateModel get(String s) {
            return null;
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public TemplateCollectionModel keys() {
            return EMPTY_COLLECTION;
        }

        public TemplateCollectionModel values() {
            return EMPTY_COLLECTION;
        }
    }
}

