/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.compiler;

import java.io.File;
import java.io.IOException;
import net.jangaroo.exml.ExmlcException;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.config.ExmlcCommandLineParser;
import net.jangaroo.exml.generator.ExmlComponentClassGenerator;
import net.jangaroo.exml.generator.ExmlConfigClassGenerator;
import net.jangaroo.exml.generator.ExmlConfigPackageXsdGenerator;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.exml.parser.ExmlToModelParser;
import net.jangaroo.jooc.config.CommandLineParseException;

public final class Exmlc {
    private final ConfigClassRegistry configClassRegistry;
    private final ExmlToConfigClassParser exmlToConfigClassParser;
    private final ExmlConfigClassGenerator exmlConfigClassGenerator;
    private final ExmlToModelParser exmlToModelParser;
    private final ExmlComponentClassGenerator exmlComponentClassGenerator;
    private final ExmlConfigPackageXsdGenerator exmlConfigPackageXsdGenerator;

    public Exmlc(ExmlConfiguration config) {
        try {
            this.configClassRegistry = new ConfigClassRegistry(config);
        }
        catch (IOException e) {
            throw new ExmlcException("unable to build config class registry: " + e.getMessage(), e);
        }
        this.exmlToConfigClassParser = new ExmlToConfigClassParser(config);
        this.exmlConfigClassGenerator = new ExmlConfigClassGenerator(config);
        this.exmlToModelParser = new ExmlToModelParser(this.configClassRegistry);
        this.exmlComponentClassGenerator = new ExmlComponentClassGenerator(config);
        this.exmlConfigPackageXsdGenerator = new ExmlConfigPackageXsdGenerator(config);
    }

    public ExmlConfigPackageXsdGenerator getExmlConfigPackageXsdGenerator() {
        return this.exmlConfigPackageXsdGenerator;
    }

    public ExmlComponentClassGenerator getExmlComponentClassGenerator() {
        return this.exmlComponentClassGenerator;
    }

    public ConfigClassRegistry getConfigClassRegistry() {
        return this.configClassRegistry;
    }

    public ExmlConfiguration getConfig() {
        return this.configClassRegistry.getConfig();
    }

    public void generateAllConfigClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            this.generateConfigClass(sourceFile);
        }
    }

    public File generateConfigClass(File source) {
        ConfigClass configClass;
        try {
            configClass = this.exmlToConfigClassParser.parseExmlToConfigClass(source);
        }
        catch (IOException e) {
            throw new ExmlcException("unable to parse EXML classes: " + e.getMessage(), source, e);
        }
        File targetFile = this.exmlConfigClassGenerator.computeConfigClassTarget(configClass.getName());
        if (this.exmlConfigClassGenerator.mustGenerateConfigClass(source, targetFile)) {
            try {
                this.exmlConfigClassGenerator.generateClass(configClass, targetFile);
            }
            catch (Exception e) {
                throw new ExmlcException("unable to generate config class: " + e.getMessage(), targetFile, e);
            }
        }
        return targetFile;
    }

    public File generateComponentClass(File exmlSourceFile) {
        try {
            ExmlModel exmlModel = this.exmlToModelParser.parse(exmlSourceFile);
            return this.exmlComponentClassGenerator.generateClass(exmlModel);
        }
        catch (Exception e) {
            throw new ExmlcException("unable to generate component class: " + e.getMessage(), exmlSourceFile, e);
        }
    }

    public void generateAllComponentClasses() {
        for (File sourceFile : this.getConfig().getSourceFiles()) {
            if (!sourceFile.getName().endsWith(".exml")) continue;
            this.generateComponentClass(sourceFile);
        }
    }

    public File generateXsd() {
        try {
            return this.exmlConfigPackageXsdGenerator.generateXsdFile(this.configClassRegistry);
        }
        catch (Exception e) {
            throw new ExmlcException("unable to generate xsd file: " + e.getMessage(), e);
        }
    }

    public static int run(String[] argv) {
        ExmlcCommandLineParser parser2 = new ExmlcCommandLineParser();
        ExmlConfiguration exmlConfiguration = null;
        try {
            exmlConfiguration = parser2.parse(argv);
        }
        catch (CommandLineParseException e) {
            System.err.println(e.getMessage());
            return e.getExitCode();
        }
        if (exmlConfiguration != null) {
            Exmlc exmlc = new Exmlc(exmlConfiguration);
            exmlc.generateAllConfigClasses();
            exmlc.generateAllComponentClasses();
            exmlc.generateXsd();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Exmlc.run(argv);
        if (result != 0) {
            System.exit(result);
        }
    }
}

