/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.util.Deque;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import net.jangaroo.exml.ExmlConstants;
import net.jangaroo.exml.ExmlcException;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.utils.CharacterRecordingHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ExmlMetadataHandler
extends CharacterRecordingHandler {
    private ConfigClass configClass;
    private Locator locator;
    private Deque<QName> elementPath = new LinkedList<QName>();

    public ExmlMetadataHandler(ConfigClass configClass) {
        this.configClass = configClass;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (ExmlConstants.isExmlNamespace(uri)) {
            if ("cfg".equals(localName)) {
                this.configClass.addCfg(new ConfigAttribute(atts.getValue("name"), atts.getValue("type"), null));
            } else if ("description".equals(localName) && (this.isLastInPathComponent() || this.isLastInPathConfig())) {
                this.startRecordingCharacters();
            }
        } else if (this.elementPath.size() == 1) {
            if (this.configClass.getSuperClassName() != null) {
                throw new ExmlcException("root node of EXML contained more than one component definition", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            String thePackage = ExmlConstants.parsePackageFromNamespace(uri);
            if (thePackage == null) {
                throw new ExmlcException("namespace '" + uri + "' of superclass element in EXML file does not denote a config package", this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            this.configClass.setSuperClassName(thePackage + "." + localName);
        }
        this.elementPath.push(new QName(uri, localName));
    }

    private boolean isLastInPathComponent() {
        QName parent = this.elementPath.peek();
        return ExmlConstants.isExmlNamespace(parent.getNamespaceURI()) && "component".equals(parent.getLocalPart());
    }

    private boolean isLastInPathConfig() {
        QName parent = this.elementPath.peek();
        return ExmlConstants.isExmlNamespace(parent.getNamespaceURI()) && "cfg".equals(parent.getLocalPart());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ExmlConstants.isExmlNamespace(uri)) {
            String characters;
            this.elementPath.pop();
            if ("description".equals(localName) && (characters = this.popRecordedCharacters()) != null) {
                if (this.isLastInPathConfig()) {
                    this.configClass.getCfgs().get(this.configClass.getCfgs().size() - 1).setDescription(characters.trim());
                } else if (this.isLastInPathComponent()) {
                    this.configClass.setDescription(characters.trim());
                }
            }
        }
    }
}

