/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.ApiCodeGenerator;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.config.JoocOptions;

public class SingleFileCompilationUnitSinkFactory
extends AbstractCompilationUnitSinkFactory {
    private String suffix;
    private boolean generateApi;

    public SingleFileCompilationUnitSinkFactory(JoocOptions options, File destinationDir, boolean generateApi, String suffix) {
        super(options, destinationDir);
        this.suffix = suffix;
        this.generateApi = generateApi;
    }

    protected File getOutputFile(File sourceFile, String[] packageName) {
        return new File(this.getOutputFileName(sourceFile, packageName));
    }

    protected String getOutputFileName(File sourceFile, String[] packageName) {
        String result;
        if (this.getOutputDir() == null) {
            result = sourceFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        } else {
            result = this.getOutputDir().getAbsolutePath();
            StringBuilder buffy = new StringBuilder(result);
            for (String aPackageName : packageName) {
                buffy.append(File.separator);
                buffy.append(aPackageName);
            }
            result = buffy.toString();
        }
        result = result + File.separator;
        result = result + sourceFile.getName();
        int dotpos = result.lastIndexOf(46);
        if (dotpos >= 0) {
            result = result.substring(0, dotpos);
        }
        result = result + this.suffix;
        return result;
    }

    @Override
    public CompilationUnitSink createSink(PackageDeclaration packageDeclaration, IdeDeclaration primaryDeclaration, File sourceFile, final boolean verbose) {
        String className;
        final File outFile = this.getOutputFile(sourceFile, packageDeclaration.getQualifiedName());
        String fileName = outFile.getName();
        String classPart = fileName.substring(0, fileName.lastIndexOf(46));
        if (!classPart.equals(className = primaryDeclaration.getName())) {
            Jooc.warning(primaryDeclaration.getSymbol(), "class name should be equal to file name: expected " + classPart + ", found " + className);
        }
        this.createOutputDirs(outFile);
        return new CompilationUnitSink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeOutput(CompilationUnit compilationUnit) {
                if (verbose) {
                    System.out.println("writing file: '" + outFile.getAbsolutePath() + "'");
                }
                try {
                    JsWriter out = new JsWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    try {
                        try {
                            out.setOptions(SingleFileCompilationUnitSinkFactory.this.getOptions());
                            if (SingleFileCompilationUnitSinkFactory.this.generateApi) {
                                compilationUnit.visit(new ApiCodeGenerator(out));
                            } else {
                                compilationUnit.visit(new JsCodeGenerator(out));
                            }
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        outFile.delete();
                        throw Jooc.error("error writing file: '" + outFile.getAbsolutePath() + "'", e);
                    }
                }
                catch (IOException e) {
                    throw Jooc.error("cannot open output file for writing: '" + outFile.getAbsolutePath() + "'", e);
                }
            }
        };
    }
}

