/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.exml.model.DescriptionHolder;
import net.jangaroo.utils.CompilerUtils;

public final class ConfigClass
extends DescriptionHolder {
    private List<ConfigAttribute> cfgs = new ArrayList<ConfigAttribute>();
    private Map<String, ConfigAttribute> cfgsByName = new HashMap<String, ConfigAttribute>();
    private String name;
    private String packageName;
    private String superClassName;
    private ConfigClass superClass;
    private String componentClassName;
    private ConfigClassType type;
    private String typeValue;

    public void addCfg(ConfigAttribute cfg) {
        this.cfgs.add(cfg);
        this.cfgsByName.put(cfg.getName(), cfg);
    }

    public ConfigClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ConfigClass superClass) {
        this.superClass = superClass;
    }

    public List<ConfigAttribute> getCfgs() {
        return this.cfgs;
    }

    public List<ConfigAttribute> getDirectCfgs() {
        ConfigClass cc = this.getSuperClass();
        if (cc != null) {
            ArrayList<ConfigAttribute> directCfgs = new ArrayList<ConfigAttribute>(this.cfgs);
            do {
                directCfgs.removeAll(cc.getCfgs());
            } while ((cc = cc.getSuperClass()) != null);
            return directCfgs;
        }
        return this.cfgs;
    }

    public ConfigAttribute getCfgByName(String name) {
        return this.cfgsByName.get(name);
    }

    public static String createConfigClassName(String name) {
        return CompilerUtils.uncapitalize(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConfigClassType getType() {
        return this.type;
    }

    public void setType(ConfigClassType type) {
        this.type = type;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(String typeValue) {
        this.typeValue = typeValue;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getNs() {
        String[] parts = this.packageName.split("\\.");
        StringBuilder ns = new StringBuilder();
        for (String part : parts) {
            ns.append(part.charAt(0));
        }
        return ns.toString();
    }

    public String getFullName() {
        return this.packageName + "." + this.name;
    }

    public void setComponentClassName(String componentClassName) {
        this.componentClassName = componentClassName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigClass that = (ConfigClass)o;
        if (this.cfgs != null ? !((Object)this.cfgs).equals(that.cfgs) : that.cfgs != null) {
            return false;
        }
        if (this.componentClassName != null ? !this.componentClassName.equals(that.componentClassName) : that.componentClassName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        if (this.superClassName != null ? !this.superClassName.equals(that.superClassName) : that.superClassName != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.cfgs != null ? ((Object)this.cfgs).hashCode() : 0;
        result = 31 * result + (this.cfgsByName != null ? ((Object)this.cfgsByName).hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.superClassName != null ? this.superClassName.hashCode() : 0);
        result = 31 * result + (this.componentClassName != null ? this.componentClassName.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

