/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class IdeExpr
extends Expr {
    private Ide ide;

    public IdeExpr(JooSymbol symIde) {
        this(new Ide(symIde));
    }

    public IdeExpr(Ide ide) {
        this.ide = ide;
    }

    public static IdeExpr fromPrefix(JooSymbol symPrefix, JooSymbol symDot, Ide ide) {
        return new IdeExpr(ide.qualify(symPrefix, symDot));
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitIdeExpression(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getIde().analyze(this);
        this.getIde().analyzeAsExpr(parentNode, this);
        this.setType(this.getIde().resolveDeclaration());
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde().getSymbol();
    }

    @Override
    public boolean isCompileTimeConstant() {
        PackageDeclaration packageDeclaration;
        IdeDeclaration ideDeclaration = this.getIde().getDeclaration(false);
        if (ideDeclaration instanceof FunctionDeclaration && ((FunctionDeclaration)ideDeclaration).isGetter() && (packageDeclaration = ideDeclaration.getPackageDeclaration()) != null && "".equals(packageDeclaration.getName())) {
            return true;
        }
        return ideDeclaration instanceof VariableDeclaration && ((VariableDeclaration)ideDeclaration).isCompileTimeConstant() && ideDeclaration.getClassDeclaration() != this.getIde().getScope().getClassDeclaration();
    }

    public Ide getIde() {
        return this.ide;
    }
}

