/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.utils.AS3Type;

public class VariableDeclaration
extends TypedIdeDeclaration {
    private static final Map<AS3Type, String> DEFAULT_VALUE_BY_TYPE = new HashMap<AS3Type, String>(10);
    private JooSymbol optSymConstOrVar;
    private Initializer optInitializer;
    private VariableDeclaration optNextVariableDeclaration;
    private JooSymbol optSymSemicolon;
    private Boolean declaringCompileTimeConstant = null;
    private VariableDeclaration previousVariableDeclaration;

    public VariableDeclaration(JooSymbol[] modifiers, JooSymbol optSymConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer, VariableDeclaration optNextVariableDeclaration, JooSymbol optSymSemicolon) {
        super(modifiers, ide, optTypeRelation);
        this.optSymConstOrVar = optSymConstOrVar;
        this.optInitializer = optInitializer;
        this.optNextVariableDeclaration = optNextVariableDeclaration;
        this.optSymSemicolon = optSymSemicolon;
        if (optNextVariableDeclaration != null) {
            optNextVariableDeclaration.previousVariableDeclaration = this;
            if (optSymSemicolon != null) {
                optNextVariableDeclaration.setInheritedModifiers(modifiers);
            }
        }
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optInitializer, this.optNextVariableDeclaration);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitVariableDeclaration(this);
    }

    @Override
    protected int getAllowedModifiers() {
        return 543;
    }

    public VariableDeclaration(JooSymbol symConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer, VariableDeclaration optNextVariableDeclaration, JooSymbol optSymSemicolon) {
        this(new JooSymbol[0], symConstOrVar, ide, optTypeRelation, optInitializer, optNextVariableDeclaration, optSymSemicolon);
    }

    public VariableDeclaration(JooSymbol symConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer, VariableDeclaration optNextVariableDeclaration) {
        this(symConstOrVar, ide, optTypeRelation, optInitializer, optNextVariableDeclaration, null);
    }

    public VariableDeclaration(JooSymbol symConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer) {
        this(symConstOrVar, ide, optTypeRelation, optInitializer, null);
    }

    public VariableDeclaration(JooSymbol symConstOrVar, Ide ide, TypeRelation optTypeRelation) {
        this(symConstOrVar, ide, optTypeRelation, null, null, null);
    }

    @Override
    protected void setInheritedModifiers(JooSymbol[] modifiers) {
        super.setInheritedModifiers(modifiers);
        if (this.getOptNextVariableDeclaration() != null) {
            this.getOptNextVariableDeclaration().setInheritedModifiers(modifiers);
        }
    }

    @Override
    public void setClassMember(boolean classMember) {
        super.setClassMember(classMember);
        if (this.getOptNextVariableDeclaration() != null) {
            this.getOptNextVariableDeclaration().setClassMember(classMember);
        }
    }

    @Override
    public boolean isDeclaringCompileTimeConstant() {
        if (this.declaringCompileTimeConstant == null) {
            this.declaringCompileTimeConstant = false;
            if (this.isConst()) {
                this.declaringCompileTimeConstant = this.getOptInitializer() == null || this.getOptInitializer().getValue().isCompileTimeConstant();
            }
        }
        return this.declaringCompileTimeConstant;
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getOptInitializer() == null && this.isConst()) {
            Jooc.warning(this.getOptSymConstOrVar(), "constant should be initialized");
        }
        if (this.getOptInitializer() != null) {
            this.getOptInitializer().analyze(this);
        }
        if (this.getOptNextVariableDeclaration() != null) {
            this.getOptNextVariableDeclaration().analyze(this);
        }
        if (this.isClassMember() && !this.isStatic() && this.getOptInitializer() != null && !this.getOptInitializer().getValue().isRuntimeConstant()) {
            this.getClassDeclaration().addFieldWithInitializer(this);
        }
        if (this.isClassMember() && this.isConst() && this.isPublicApi() && this.getOptInitializer() != null && this.getOptInitializer().getValue().isCompileTimeConstant()) {
            this.getOptInitializer().addPublicApiDependencies();
        }
    }

    public static String getDefaultValue(TypeRelation typeRelation) {
        AS3Type type = typeRelation == null ? AS3Type.ANY : AS3Type.typeByName(typeRelation.getType().getSymbol().getText());
        String emptyValue = DEFAULT_VALUE_BY_TYPE.get((Object)type);
        if (emptyValue == null) {
            emptyValue = "null";
        }
        return emptyValue;
    }

    @Override
    boolean allowDuplicates(Scope scope) {
        return !this.isClassMember();
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        if (this.getOptInitializer() != null) {
            this.getOptInitializer().scope(scope);
        }
        if (this.getOptNextVariableDeclaration() != null) {
            this.getOptNextVariableDeclaration().scope(scope);
        }
    }

    public boolean hasPreviousVariableDeclaration() {
        return this.previousVariableDeclaration != null;
    }

    protected VariableDeclaration getPreviousVariableDeclaration() {
        return this.previousVariableDeclaration;
    }

    protected VariableDeclaration getFirstVariableDeclaration() {
        VariableDeclaration firstVariableDeclaration = this;
        while (firstVariableDeclaration.hasPreviousVariableDeclaration()) {
            firstVariableDeclaration = firstVariableDeclaration.getPreviousVariableDeclaration();
        }
        return firstVariableDeclaration;
    }

    @Override
    public int getModifiers() {
        return this.hasPreviousVariableDeclaration() ? this.getFirstVariableDeclaration().getModifiers() : super.getModifiers();
    }

    public boolean isConst() {
        VariableDeclaration firstVariableDeclaration = this.getFirstVariableDeclaration();
        return firstVariableDeclaration.getOptSymConstOrVar() != null && firstVariableDeclaration.getOptSymConstOrVar().sym == 7;
    }

    public JooSymbol getOptSymConstOrVar() {
        return this.optSymConstOrVar;
    }

    public Initializer getOptInitializer() {
        return this.optInitializer;
    }

    public VariableDeclaration getOptNextVariableDeclaration() {
        return this.optNextVariableDeclaration;
    }

    public JooSymbol getOptSymSemicolon() {
        return this.optSymSemicolon;
    }

    static {
        DEFAULT_VALUE_BY_TYPE.put(AS3Type.BOOLEAN, "false");
        DEFAULT_VALUE_BY_TYPE.put(AS3Type.INT, "0");
        DEFAULT_VALUE_BY_TYPE.put(AS3Type.NUMBER, "NaN");
        DEFAULT_VALUE_BY_TYPE.put(AS3Type.UINT, "0");
        DEFAULT_VALUE_BY_TYPE.put(AS3Type.ANY, "undefined");
    }
}

