/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Statement;

public abstract class Declaration
extends Statement {
    protected static final int MODIFIER_PUBLIC = 1;
    protected static final int MODIFIER_PROTECTED = 2;
    protected static final int MODIFIER_PRIVATE = 4;
    protected static final int MODIFIER_INTERNAL = 8;
    protected static final int MODIFIER_STATIC = 16;
    protected static final int MODIFIER_ABSTRACT = 32;
    protected static final int MODIFIER_FINAL = 64;
    protected static final int MODIFIER_OVERRIDE = 128;
    protected static final int MODIFIER_DYNAMIC = 256;
    protected static final int MODIFIER_NAMESPACE = 512;
    protected static final int MODIFIER_NATIVE = 1024;
    protected static final int MODIFIER_VIRTUAL = 2048;
    protected static final int MODIFIERS_SCOPE = 527;
    private JooSymbol[] symModifiers;
    private JooSymbol[] symInheritedModifiers = new JooSymbol[0];
    private AstNode parentDeclaration = null;
    private ClassDeclaration classDeclaration = null;
    private int modifiers = -1;

    protected Declaration(JooSymbol[] modifiers) {
        this.symModifiers = (JooSymbol[])modifiers.clone();
        this.computeModifiers();
    }

    public AstNode getParentDeclaration() {
        return this.parentDeclaration;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    protected void setInheritedModifiers(JooSymbol[] modifiers) {
        this.setSymInheritedModifiers(modifiers);
        this.computeModifiers();
    }

    protected void computeModifiers() {
        this.modifiers = 0;
        for (JooSymbol modifier : this.getSymModifiers()) {
            this.computeModifier(modifier);
        }
        for (JooSymbol modifier : this.getSymInheritedModifiers()) {
            this.computeModifier(modifier);
        }
    }

    private void computeModifier(JooSymbol modifier) {
        int flag = this.getModifierFlag(modifier);
        if ((flag & this.modifiers) != 0) {
            throw Jooc.error(modifier, "duplicate modifier '" + modifier.getText() + "'");
        }
        if ((flag & 0x20F) != 0 && (this.modifiers & 0x20F) != 0) {
            throw Jooc.error(modifier, "duplicate scope modifier '" + modifier.getText() + "'");
        }
        this.modifiers |= flag;
    }

    private void checkAllowedModifiers() {
        int allowedModifiers = this.getAllowedModifiers();
        for (JooSymbol modifier : this.getSymModifiers()) {
            int flag = this.getModifierFlag(modifier);
            if ((allowedModifiers & flag) != 0) continue;
            throw Jooc.error(modifier, "modifier '" + modifier.getText() + "' not allowed here");
        }
    }

    protected int getAllowedModifiers() {
        return 0;
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.checkAllowedModifiers();
    }

    protected int getModifierFlag(JooSymbol modifier) {
        switch (modifier.sym) {
            case 29: {
                return 1;
            }
            case 28: {
                return 2;
            }
            case 27: {
                return 4;
            }
            case 23: {
                return 8;
            }
            case 99: {
                return modifier.getText().equals("dynamic") ? 256 : (modifier.getText().equals("static") ? 16 : (modifier.getText().equals("final") ? 64 : (modifier.getText().equals("native") ? 1024 : (modifier.getText().equals("override") ? 128 : (modifier.getText().equals("virtual") ? 2048 : 512)))));
            }
        }
        throw Jooc.error(modifier, "internal compiler error: invalid modifier '" + modifier.getText() + "'");
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getModifiers() & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.getModifiers() & 4) != 0;
    }

    public boolean isOverride() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isPublicApi() {
        return this.isPublic() || this.isProtected();
    }

    public boolean isPrivateStatic() {
        return this.isPrivate() && this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isNative() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public void scope(Scope scope) {
        this.setParentDeclaration(scope.getDefiningNode());
        this.setClassDeclaration(scope.getClassDeclaration());
    }

    public JooSymbol[] getSymInheritedModifiers() {
        return (JooSymbol[])this.symInheritedModifiers.clone();
    }

    public void setSymInheritedModifiers(JooSymbol[] symInheritedModifiers) {
        this.symInheritedModifiers = (JooSymbol[])symInheritedModifiers.clone();
    }

    public void setParentDeclaration(AstNode parentDeclaration) {
        this.parentDeclaration = parentDeclaration;
    }

    public void setClassDeclaration(ClassDeclaration classDeclaration) {
        this.classDeclaration = classDeclaration;
    }

    public JooSymbol[] getSymModifiers() {
        return (JooSymbol[])this.symModifiers.clone();
    }
}

