/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.LinkedHashSet;
import java.util.Set;
import net.jangaroo.exml.json.JsonObject;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.DescriptionHolder;

public class ExmlModel
extends DescriptionHolder {
    private String packageName;
    private String className;
    private String superClassName;
    private Set<String> imports = new LinkedHashSet<String>();
    private JsonObject jsonObject = new JsonObject(new Object[0]);
    private ConfigClass configClass;

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.packageName.length() > 0 ? this.packageName + "." + this.className : this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public void addImport(String importedClassName) {
        this.imports.add(importedClassName);
    }

    public ConfigClass getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(ConfigClass configClass) {
        this.configClass = configClass;
        this.addImport(configClass.getFullName());
    }

    public static String createComponentClassName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return new StringBuilder(name.length()).append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
    }
}

