/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;

public abstract class AbstractCompileLog
implements CompileLog {
    protected boolean errors = false;

    String formatError(String fileName, int line, int column, String debugLevel, String message) {
        StringBuilder m = new StringBuilder();
        m.append(fileName);
        m.append("(");
        m.append(line);
        m.append("): ");
        m.append(debugLevel);
        m.append(": ");
        m.append("in column ");
        m.append(column);
        m.append(": ");
        m.append(message);
        return m.toString();
    }

    @Override
    public void error(FilePosition position, String msg) {
        this.error(this.formatError(position.getFileName(), position.getLine(), position.getColumn(), "Error", msg));
    }

    @Override
    public void warning(FilePosition position, String msg) {
        this.warning(this.formatError(position.getFileName(), position.getLine(), position.getColumn(), "Warning", msg));
    }

    @Override
    public boolean hasErrors() {
        return this.errors;
    }

    @Override
    public void error(String msg) {
        this.doLogError(msg);
        this.errors = true;
    }

    protected abstract void doLogError(String var1);
}

