/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.compiler.Exmlc;
import net.jangaroo.exml.json.JsonArray;
import net.jangaroo.exml.json.JsonObject;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.xml.PreserveLineNumberHandler;
import net.jangaroo.utils.CompilerUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ExmlToModelParser {
    private static final String EXT_CONFIG_PREFIX = "ext.config.";
    private final ConfigClassRegistry registry;

    public ExmlToModelParser(ConfigClassRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExmlModel parse(File file) throws IOException, SAXException {
        ExmlModel model = new ExmlModel();
        String qName = CompilerUtils.qNameFromFile(this.registry.getConfig().findSourceDir(file), file);
        String className = CompilerUtils.className(qName);
        model.setClassName(ExmlModel.createComponentClassName(className));
        ConfigClass configClassByName = this.registry.getConfigClassByName(this.registry.getConfig().getConfigClassPackage() + "." + ConfigClass.createConfigClassName(className));
        model.setConfigClass(configClassByName);
        model.setPackageName(CompilerUtils.packageName(qName));
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.parse(inputStream, model);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return model;
    }

    private void parse(InputStream inputStream, ExmlModel model) throws IOException, SAXException {
        Document document = this.buildDom(inputStream);
        Node root = document.getFirstChild();
        this.validateRootNode(root);
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!"baseClass".equals(attribute.getLocalName())) continue;
            model.setSuperClassName(attribute.getValue());
        }
        NodeList childNodes = root.getChildNodes();
        Node componentNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (Exmlc.isExmlNamespace(node.getNamespaceURI())) {
                if ("import".equals(node.getLocalName())) {
                    String importedClassName = ((Element)node).getAttribute("class");
                    if (importedClassName == null || importedClassName.equals("")) {
                        int lineNumber = this.getLineNumber(componentNode);
                        throw new ExmlcException("<exml:import> element must contain a non-empty class attribute", lineNumber);
                    }
                    model.addImport(importedClassName);
                    continue;
                }
                if (!"description".equals(node.getLocalName())) continue;
                model.setDescription(node.getTextContent().trim());
                continue;
            }
            if (componentNode != null) {
                int lineNumber = this.getLineNumber(componentNode);
                throw new ExmlcException("root node of EXML contained more than one component definition", lineNumber);
            }
            componentNode = node;
        }
        if (componentNode == null) {
            int lineNumber = this.getLineNumber(root);
            throw new ExmlcException("root node of EXML did not contain a component definition", lineNumber);
        }
        String superFullClassName = this.createFullConfigClassNameFromNode(componentNode);
        if (superFullClassName.equals(model.getConfigClass().getFullName())) {
            int lineNumber = this.getLineNumber(componentNode);
            throw new ExmlcException("Cyclic inheritance error: super class and this component are the same!. There is something wrong!", lineNumber);
        }
        ConfigClass supberConfigClass = this.getConfigClassByName(superFullClassName, componentNode);
        String superComponentClassName = supberConfigClass.getComponentClassName();
        if (model.getSuperClassName() == null) {
            model.setSuperClassName(superComponentClassName);
        }
        model.addImport(superComponentClassName);
        this.fillModelAttributes(model, model.getJsonObject(), componentNode, supberConfigClass);
    }

    private String createFullConfigClassNameFromNode(Node componentNode) {
        String name = componentNode.getLocalName();
        String uri = componentNode.getNamespaceURI();
        String packageName = Exmlc.parsePackageFromNamespace(uri);
        if (packageName == null) {
            int lineNumber = this.getLineNumber(componentNode);
            throw new ExmlcException("namespace '" + uri + "' of element '" + name + "' in EXML file does not denote a config package", lineNumber);
        }
        return packageName + "." + name;
    }

    private void fillModelAttributes(ExmlModel model, JsonObject jsonObject, Node componentNode, ConfigClass configClass) {
        NamedNodeMap attributes = componentNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            ConfigAttribute configAttribute = this.getCfgByName(configClass, attributeName);
            this.setAttribute(jsonObject, attributeName, attributeValue, configAttribute);
        }
        this.fillModelAttributesFromSubelements(model, jsonObject, componentNode, configClass);
    }

    private void setAttribute(JsonObject jsonObject, String attributeName, String attributeValue, ConfigAttribute configAttribute) {
        if (this.isCodeExpression(attributeValue)) {
            jsonObject.set(attributeName, attributeValue);
        } else if (configAttribute == null) {
            this.setUntypedAttribute(jsonObject, attributeName, attributeValue);
        } else {
            String type = configAttribute.getType();
            if ("Boolean".equals(type)) {
                jsonObject.set(attributeName, Boolean.parseBoolean(attributeValue));
            } else if ("Number".equals(type)) {
                try {
                    jsonObject.set(attributeName, Long.parseLong(attributeValue));
                }
                catch (NumberFormatException e) {
                    jsonObject.set(attributeName, Double.parseDouble(attributeValue));
                }
            } else if ("String".equals(type)) {
                jsonObject.set(attributeName, attributeValue);
            } else if ("Array".equals(type)) {
                jsonObject.set(attributeName, new JsonArray(attributeValue));
            } else if ("*".equals(type)) {
                this.setUntypedAttribute(jsonObject, attributeName, attributeValue);
            } else {
                jsonObject.set(attributeName, attributeValue);
            }
        }
    }

    private boolean isCodeExpression(String attributeValue) {
        return attributeValue.startsWith("{") && attributeValue.endsWith("}");
    }

    private void fillModelAttributesFromSubelements(ExmlModel model, JsonObject jsonObject, Node componentNode, ConfigClass configClass) {
        NodeList childNodes = componentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String elementName = element.getLocalName();
            if (element.hasAttributes()) {
                this.parseJavaScriptObjectProperty(jsonObject, element);
                continue;
            }
            List<Object> childObjects = this.parseChildObjects(model, element);
            ConfigAttribute configAttribute = this.getCfgByName(configClass, elementName);
            if (childObjects.size() > 1 || configAttribute != null && "Array".equals(configAttribute.getType())) {
                JsonArray jsonArray = new JsonArray(childObjects.toArray());
                jsonObject.set(element.getLocalName(), jsonArray);
                continue;
            }
            if (childObjects.size() != 1) continue;
            jsonObject.set(element.getLocalName(), childObjects.get(0));
        }
    }

    private ConfigClass getConfigClassByName(String className, Node errorNode) {
        ConfigClass configClass = this.registry.getConfigClassByName(className);
        if (configClass == null) {
            int lineNumber = this.getLineNumber(errorNode);
            throw new ExmlcException("unknown type '" + className + "'", lineNumber);
        }
        return configClass;
    }

    private void parseJavaScriptObjectProperty(JsonObject jsonObject, Element propertyElement) {
        JsonObject propertyObject = new JsonObject(new Object[0]);
        this.setUntypedAttributes(propertyElement, propertyObject);
        for (Element child : this.getChildElements(propertyElement)) {
            this.parseJavaScriptObjectProperty(propertyObject, child);
        }
        jsonObject.set(propertyElement.getLocalName(), propertyObject);
    }

    private List<Element> getChildElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList propertyChildNotes = element.getChildNodes();
        for (int j = 0; j < propertyChildNotes.getLength(); ++j) {
            Node childNode = propertyChildNotes.item(j);
            if (childNode.getNodeType() != 1) continue;
            result.add((Element)childNode);
        }
        return result;
    }

    private ConfigAttribute getCfgByName(ConfigClass configClass, String attributeName) {
        ConfigClass current = configClass;
        while (current != null) {
            ConfigAttribute configAttribute = current.getCfgByName(attributeName);
            if (configAttribute != null) {
                return configAttribute;
            }
            String superClassName = current.getSuperClassName();
            if (superClassName == null || superClassName.equals("Object")) break;
            current = this.registry.getConfigClassByName(superClassName);
        }
        return null;
    }

    private List<Object> parseChildObjects(ExmlModel model, Element element) {
        ArrayList<Object> childObjects = new ArrayList<Object>();
        for (Element arrayItemNode : this.getChildElements(element)) {
            Object value;
            if (Exmlc.isExmlNamespace(arrayItemNode.getNamespaceURI()) && "object".equals(arrayItemNode.getLocalName())) {
                value = this.parseExmlObjectNode(arrayItemNode);
            } else {
                String arrayItemClassName = this.createFullConfigClassNameFromNode(arrayItemNode);
                ConfigClass configClass = this.getConfigClassByName(arrayItemClassName, arrayItemNode);
                String componentClassName = configClass.getComponentClassName();
                JsonObject arrayItemJsonObject = new JsonObject(new Object[0]);
                if (configClass.getType() == null) {
                    arrayItemJsonObject.settingWrapperClass(configClass.getComponentClassName());
                    arrayItemJsonObject.settingWrapperClassConstructorCast(configClass.getFullName());
                    model.addImport(configClass.getFullName());
                    model.addImport(componentClassName);
                } else if (arrayItemClassName.startsWith(EXT_CONFIG_PREFIX)) {
                    arrayItemJsonObject.set(configClass.getType().getExtTypeAttribute(), configClass.getTypeValue());
                } else {
                    arrayItemJsonObject.settingWrapperClass(configClass.getFullName());
                    model.addImport(configClass.getFullName());
                }
                this.fillModelAttributes(model, arrayItemJsonObject, arrayItemNode, configClass);
                value = arrayItemJsonObject;
            }
            if (value == null) continue;
            childObjects.add(value);
        }
        return childObjects;
    }

    private Object parseExmlObjectNode(Node exmlObjectNode) {
        String textContent = exmlObjectNode.getTextContent();
        if (textContent != null && textContent.length() > 0) {
            return "{" + textContent.trim() + "}";
        }
        if (!exmlObjectNode.hasAttributes()) {
            return null;
        }
        JsonObject object = new JsonObject(new Object[0]);
        this.setUntypedAttributes(exmlObjectNode, object);
        return object;
    }

    private void setUntypedAttributes(Node exmlObjectNode, JsonObject object) {
        NamedNodeMap attributes = exmlObjectNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attributeName = attribute.getLocalName();
            String attributeValue = attribute.getValue();
            this.setUntypedAttribute(object, attributeName, attributeValue);
        }
    }

    private void setUntypedAttribute(JsonObject jsonObject, String attributeName, String attributeValue) {
        try {
            jsonObject.set(attributeName, Long.parseLong(attributeValue));
            return;
        }
        catch (NumberFormatException e) {
            try {
                jsonObject.set(attributeName, Double.parseDouble(attributeValue));
                return;
            }
            catch (NumberFormatException e2) {
                if ("false".equalsIgnoreCase(attributeValue)) {
                    jsonObject.set(attributeName, Boolean.FALSE);
                    return;
                }
                if ("true".equalsIgnoreCase(attributeValue)) {
                    jsonObject.set(attributeName, Boolean.TRUE);
                    return;
                }
                jsonObject.set(attributeName, attributeValue);
                return;
            }
        }
    }

    private void validateRootNode(Node root) {
        int lineNumber = this.getLineNumber(root);
        if (!Exmlc.isExmlNamespace(root.getNamespaceURI())) {
            throw new ExmlcException("root node of EXML file must belong to namespace 'http://www.jangaroo.net/exml/0.8', but was '" + root.getNamespaceURI() + "'", lineNumber);
        }
        if (!Exmlc.EXML_ROOT_NODE_NAMES.contains(root.getLocalName())) {
            throw new ExmlcException("Root node of EXML file must be one of " + Arrays.toString(Exmlc.EXML_ROOT_NODE_NAMES.toArray()) + ", but was " + root.getLocalName() + ".", lineNumber);
        }
    }

    private int getLineNumber(Node node) {
        return Integer.parseInt((String)node.getUserData("lineNumber"));
    }

    private Document buildDom(InputStream inputStream) throws SAXException, IOException {
        Document doc;
        SAXParser parser2;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            parser2 = saxFactory.newSAXParser();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("a default dom builder should be provided", e);
        }
        PreserveLineNumberHandler handler = new PreserveLineNumberHandler(doc);
        parser2.parse(inputStream, (DefaultHandler)handler);
        return doc;
    }
}

