/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.Attr;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMAttrImpl;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class AttVal
implements Cloneable {
    public AttVal next;
    public Attribute dict;
    public Node asp;
    public Node php;
    public int delim;
    public String attribute;
    public String value;
    protected Attr adapter = null;

    public AttVal() {
        this.next = null;
        this.dict = null;
        this.asp = null;
        this.php = null;
        this.delim = 0;
        this.attribute = null;
        this.value = null;
    }

    public AttVal(AttVal attVal, Attribute attribute, int n, String string, String string2) {
        this.next = attVal;
        this.dict = attribute;
        this.asp = null;
        this.php = null;
        this.delim = n;
        this.attribute = string;
        this.value = string2;
    }

    public AttVal(AttVal attVal, Attribute attribute, Node node, Node node2, int n, String string, String string2) {
        this.next = attVal;
        this.dict = attribute;
        this.asp = node;
        this.php = node2;
        this.delim = n;
        this.attribute = string;
        this.value = string2;
    }

    public Attribute checkAttribute(Lexer lexer2, Node node) {
        Attribute attribute;
        TagTable tagTable = lexer2.configuration.tt;
        if (this.asp == null && this.php == null) {
            this.checkUniqueAttribute(lexer2, node);
        }
        if ((attribute = this.dict) != null) {
            if (attribute == AttributeTable.attrTitle && (node.tag == tagTable.tagA || node.tag == tagTable.tagLink)) {
                lexer2.versions = (short)(lexer2.versions & 0x1F);
            } else if ((attribute.versions & 0x20) != 0) {
                if (!lexer2.configuration.XmlTags && !lexer2.configuration.XmlOut) {
                    Report.attrError(lexer2, node, this.attribute, (short)9);
                }
            } else {
                lexer2.versions = (short)(lexer2.versions & attribute.versions);
            }
            if (attribute.attrchk != null) {
                attribute.attrchk.check(lexer2, node, this);
            }
        } else if (!(lexer2.configuration.XmlTags || node.tag == null || this.asp != null || node.tag != null && (node.tag.versions & 0x1C0) != 0)) {
            Report.attrError(lexer2, node, this.attribute, (short)1);
        }
        return attribute;
    }

    public void checkUniqueAttribute(Lexer lexer2, Node node) {
        int n = 0;
        AttVal attVal = this.next;
        while (attVal != null) {
            if (this.attribute != null && attVal.attribute != null && attVal.asp == null && attVal.php == null && Lexer.wstrcasecmp(this.attribute, attVal.attribute) == 0) {
                ++n;
            }
            attVal = attVal.next;
        }
        if (n > 0) {
            Report.attrError(lexer2, node, this.attribute, (short)7);
        }
    }

    protected Object clone() {
        AttVal attVal = new AttVal();
        if (this.next != null) {
            attVal.next = (AttVal)this.next.clone();
        }
        if (this.attribute != null) {
            attVal.attribute = this.attribute;
        }
        if (this.value != null) {
            attVal.value = this.value;
        }
        attVal.delim = this.delim;
        if (this.asp != null) {
            attVal.asp = (Node)this.asp.clone();
        }
        if (this.php != null) {
            attVal.php = (Node)this.php.clone();
        }
        attVal.dict = AttributeTable.getDefaultAttributeTable().findAttribute(this);
        return attVal;
    }

    protected Attr getAdapter() {
        if (this.adapter == null) {
            this.adapter = new DOMAttrImpl(this);
        }
        return this.adapter;
    }

    public boolean isBoolAttribute() {
        Attribute attribute = this.dict;
        return attribute != null && attribute.attrchk == AttrCheckImpl.getCheckBool();
    }
}

