/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.IOException;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.BreakStatement;
import net.jangaroo.jooc.ast.CaseStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ContinueStatement;
import net.jangaroo.jooc.ast.DefaultStatement;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DoStatement;
import net.jangaroo.jooc.ast.EmptyDeclaration;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.ForStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.IfStatement;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.InfixOpExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.NamespacedDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.SwitchStatement;
import net.jangaroo.jooc.ast.ThrowStatement;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.ast.WhileStatement;
import net.jangaroo.jooc.backend.CodeGeneratorBase;

public class ApiCodeGenerator
extends CodeGeneratorBase {
    public ApiCodeGenerator(JsWriter out) {
        super(out);
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        this.out.writeSymbol(typeRelation.getSymRelation());
        typeRelation.getType().getIde().visit(this);
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        this.visitIfNotNull(annotationParameter.getOptName());
        this.writeOptSymbol(annotationParameter.getOptSymEq());
        this.visitIfNotNull(annotationParameter.getValue());
    }

    @Override
    public void visitExtends(Extends anExtends) throws IOException {
        this.out.writeSymbol(anExtends.getSymExtends());
        anExtends.getSuperClass().generateCodeAsExpr(this.out);
    }

    @Override
    public void visitInitializer(Initializer initializer) throws IOException {
        if (initializer.getValue().isCompileTimeConstant()) {
            this.out.writeSymbol(initializer.getSymEq());
            initializer.getValue().visit(this);
        }
    }

    @Override
    public void visitObjectField(ObjectField objectField) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitForInitializer(ForInitializer forInitializer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        compilationUnit.getPackageDeclaration().visit(this);
        this.out.writeSymbol(compilationUnit.getLBrace());
        compilationUnit.getPrimaryDeclaration().visit(this);
        this.out.writeSymbol(compilationUnit.getRBrace());
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        this.out.writeSymbol(ide.getIde());
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        qualifiedIde.getQualifier().visit(this);
        this.out.writeSymbol(qualifiedIde.getSymDot());
        this.out.writeSymbol(qualifiedIde.getIde());
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        this.out.writeSymbol(ideWithTypeParam.getOriginalIde());
        this.out.writeSymbol(ideWithTypeParam.getSymDotLt());
        ideWithTypeParam.getType().visit(this);
        this.out.writeSymbol(ideWithTypeParam.getSymGt());
    }

    @Override
    public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
        this.out.writeSymbol(namespacedIde.getNamespace());
        this.out.writeSymbol(namespacedIde.getSymNamespaceSep());
        this.out.writeSymbol(namespacedIde.getIde());
    }

    @Override
    public void visitImplements(Implements anImplements) throws IOException {
        this.out.writeSymbol(anImplements.getSymImplements());
        this.generateImplements(anImplements.getSuperTypes());
    }

    private void generateImplements(CommaSeparatedList<Ide> superTypes) throws IOException {
        superTypes.getHead().generateCodeAsExpr(this.out);
        if (superTypes.getSymComma() != null) {
            this.out.writeSymbol(superTypes.getSymComma());
            this.generateImplements(superTypes.getTail());
        }
    }

    @Override
    public void visitType(Type type) throws IOException {
        type.getIde().visit(this);
    }

    @Override
    public void visitObjectLiteral(ObjectLiteral objectLiteral) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    private IllegalStateException shouldOnlyBeCalledForCompileTimeConstants() {
        return new IllegalStateException("should only be called for compile time constants");
    }

    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        this.visitIde(ideExpr.getIde());
    }

    @Override
    public <T extends Expr> void visitParenthesizedExpr(ParenthesizedExpr<T> parenthesizedExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral arrayLiteral) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitInfixOpExpr(InfixOpExpr infixOpExpr) throws IOException {
        infixOpExpr.getArg1().visit(this);
        this.out.writeSymbol(infixOpExpr.getOp());
        infixOpExpr.getArg2().visit(this);
    }

    @Override
    public void visitAsExpr(AsExpr asExpr) throws IOException {
        this.visitInfixOpExpr(asExpr);
    }

    @Override
    public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitIfNotNull((AstNode)parameters.getHead());
        if (parameters.getSymComma() != null) {
            this.out.writeSymbol(parameters.getSymComma());
            parameters.getTail().visit(this);
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitNewExpr(NewExpr newExpr) throws IOException {
        throw this.shouldOnlyBeCalledForCompileTimeConstants();
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        this.out.writeSymbol(classBody.getLBrace());
        for (Directive directive : classBody.getDirectives()) {
            directive.visit(this);
        }
        this.out.writeSymbol(classBody.getRBrace());
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
    }

    @Override
    public void visitDefaultStatement(DefaultStatement defaultStatement) throws IOException {
    }

    @Override
    public void visitLabeledStatement(LabeledStatement labeledStatement) throws IOException {
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) throws IOException {
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) throws IOException {
    }

    @Override
    public void visitTryStatement(TryStatement tryStatement) throws IOException {
    }

    @Override
    public void visitCatch(Catch aCatch) throws IOException {
        throw new IllegalStateException("should not occur, because we are omitting try statements");
    }

    @Override
    public void visitForInStatement(ForInStatement forInStatement) throws IOException {
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) throws IOException {
    }

    @Override
    public void visitForStatement(ForStatement forStatement) throws IOException {
    }

    @Override
    public void visitDoStatement(DoStatement doStatement) throws IOException {
    }

    @Override
    public void visitSwitchStatement(SwitchStatement switchStatement) throws IOException {
    }

    @Override
    public void visitSemicolonTerminatedStatement(SemicolonTerminatedStatement semicolonTerminatedStatement) throws IOException {
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) throws IOException {
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) throws IOException {
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) throws IOException {
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) throws IOException {
    }

    @Override
    public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) throws IOException {
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        this.writeOptSymbol(parameter.getOptSymConstOrRest());
        parameter.getIde().visit(this);
        this.visitIfNotNull(parameter.getOptTypeRelation());
        this.visitIfNotNull(parameter.getOptInitializer());
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (!variableDeclaration.isPrivate()) {
            this.writeModifiers(this.out, variableDeclaration);
            this.out.writeSymbol(variableDeclaration.getOptSymConstOrVar());
            variableDeclaration.getIde().visit(this);
            this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
            this.visitIfNotNull(variableDeclaration.getOptInitializer());
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        if (!functionDeclaration.isPrivate()) {
            this.writeModifiers(this.out, functionDeclaration);
            if (!(functionDeclaration.isNative() || functionDeclaration.isAbstract() || functionDeclaration.isConstructor())) {
                this.out.writeSymbolWhitespace(functionDeclaration.getFun().getFunSymbol());
                this.out.writeToken("native");
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol(), false);
            } else {
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
            }
            this.writeOptSymbol(functionDeclaration.getSymGetOrSet());
            functionDeclaration.getIde().visit(this);
            this.generateSignatureAsApiCode(this.out, functionDeclaration.getFun());
            if (functionDeclaration.isConstructor() && !functionDeclaration.isNative()) {
                FunctionDeclaration superConstructor;
                ClassDeclaration superType;
                this.out.writeToken("{super(");
                if (functionDeclaration.getClassDeclaration() != null && (superType = functionDeclaration.getClassDeclaration().getSuperTypeDeclaration()) != null && (superConstructor = superType.getConstructor()) != null) {
                    boolean first = true;
                    for (Parameters superParameters = superConstructor.getParams(); superParameters != null && ((Parameter)superParameters.getHead()).getOptInitializer() == null; superParameters = superParameters.getTail()) {
                        if (first) {
                            first = false;
                        } else {
                            this.out.writeToken(",");
                        }
                        this.out.write(VariableDeclaration.getDefaultValue(((Parameter)superParameters.getHead()).getOptTypeRelation()));
                    }
                }
                this.out.writeToken(");}");
            } else {
                this.out.writeToken(";");
            }
        }
    }

    public void generateSignatureAsApiCode(JsWriter out, FunctionExpr fun) throws IOException {
        out.writeSymbol(fun.getLParen());
        this.visitIfNotNull(fun.getParams());
        out.writeSymbol(fun.getRParen());
        this.visitIfNotNull(fun.getOptTypeRelation());
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        this.visitAll(classDeclaration.getDirectives());
        this.writeModifiers(this.out, classDeclaration);
        this.out.writeSymbol(classDeclaration.getSymClass());
        classDeclaration.getIde().visit(this);
        this.visitIfNotNull(classDeclaration.getOptExtends());
        this.visitIfNotNull(classDeclaration.getOptImplements());
        classDeclaration.getBody().visit(this);
    }

    @Override
    public void visitNamespacedDeclaration(NamespacedDeclaration namespacedDeclaration) throws IOException {
        this.writeModifiers(this.out, namespacedDeclaration);
        this.out.writeSymbol(namespacedDeclaration.getSymNamespace());
        namespacedDeclaration.getIde().visit(this);
        if (namespacedDeclaration.getOptInitializer() != null) {
            this.out.writeSymbol(namespacedDeclaration.getOptInitializer().getSymEq());
            namespacedDeclaration.getOptInitializer().getValue().visit(this);
        }
        this.writeOptSymbol(namespacedDeclaration.getOptSymSemicolon(), ";");
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        this.out.writeSymbol(packageDeclaration.getSymPackage());
        this.visitIfNotNull(packageDeclaration.getIde());
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        this.out.writeSymbol(annotation.getLeftBracket());
        annotation.getIde().visit(this);
        this.writeOptSymbol(annotation.getOptLeftParen());
        this.visitIfNotNull(annotation.getOptAnnotationParameters());
        this.writeOptSymbol(annotation.getOptRightParen());
        this.out.writeSymbol(annotation.getRightBracket());
    }

    @Override
    public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) throws IOException {
        if (importDirective.isExplicit()) {
            this.out.writeSymbol(importDirective.getImportKeyword());
            importDirective.getIde().visit(this);
            this.out.writeSymbol(importDirective.getSymSemicolon());
        }
    }
}

