/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.utils;

import java.util.Set;

public class ExmlUtils {
    public static String parsePackageFromNamespace(String uri) {
        return uri.startsWith("exml:") ? uri.substring("exml:".length()) : null;
    }

    public static boolean isExmlNamespace(String uri) {
        return "http://www.jangaroo.net/exml/0.8".equals(uri);
    }

    public static boolean isCodeExpression(String attributeValue) {
        return attributeValue.startsWith("{") && attributeValue.endsWith("}");
    }

    public static String getCodeExpression(String attributeValue) {
        return attributeValue.substring(1, attributeValue.length() - 1);
    }

    public static void addImport(Set<String> imports, String importedClassName) {
        if (importedClassName != null && importedClassName.contains(".")) {
            imports.add(importedClassName);
        }
    }

    public static String createComponentClassName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return new StringBuilder(name.length()).append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
    }
}

