/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.as;

import java.io.IOException;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassType;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitorBase;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.utils.AS3Type;

public class ConfigClassBuilder
extends AstVisitorBase {
    private static final String EXT_CONFIG_META_NAME = "ExtConfig";
    private static final String TARGET_ANNOTATION_PARAMETER_NAME = "target";
    private static final String COMMENT_START = "/*";
    private static final String COMMENT_END = "*/";
    private static final String LINE_COMMENT_START = "//";
    private static final String ASDOC_COMMENT_START = "/**";
    private String configClassName;
    private ConfigClass configClass;
    private CompilationUnit compilationUnit;

    public ConfigClassBuilder(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public ConfigClass buildConfigClass() {
        try {
            this.compilationUnit.visit(this);
        }
        catch (IOException e) {
            throw new IllegalStateException("should not happen, because the ConfigClassBuilder does not do I/O", e);
        }
        return this.configClass.getComponentClassName() == null ? (this.configClassName == null ? null : new ConfigClass(this.configClassName)) : this.configClass;
    }

    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        this.configClass = new ConfigClass();
        compilationUnit.getPackageDeclaration().visit(this);
        for (AstNode node : compilationUnit.getDirectives()) {
            node.visit(new ClassAnnotationsVisitor());
        }
        compilationUnit.getPrimaryDeclaration().visit(this);
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        String packageName = packageDeclaration.getQualifiedNameStr();
        this.configClass.setPackageName(packageName);
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        String name = classDeclaration.getName();
        this.configClass.setName(name);
        ClassDeclaration superTypeDeclaration = classDeclaration.getSuperTypeDeclaration();
        String superClassName = superTypeDeclaration == null ? null : ("Object".equals(superTypeDeclaration.getQualifiedNameStr()) ? null : superTypeDeclaration.getQualifiedNameStr());
        this.configClass.setSuperClassName(superClassName);
        String description = ConfigClassBuilder.parseDescription(classDeclaration.getSymClass(), classDeclaration.getSymModifiers());
        if (description != null && description.trim().length() > 0) {
            this.configClass.setDescription(description);
        }
        classDeclaration.getBody().visit(this);
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        for (Directive node : classBody.getDirectives()) {
            node.visit(new ClassBodyVisitor());
        }
    }

    public static String parseDescription(JooSymbol symbol2, JooSymbol[] symModifiers) {
        JooSymbol firstSymbol = symbol2;
        if (symModifiers.length > 0) {
            firstSymbol = symModifiers[0];
        }
        String whitespace = firstSymbol.getWhitespace();
        int pos = 0;
        String lastAsDocComment = null;
        while (true) {
            int commentStart = whitespace.indexOf(COMMENT_START, pos);
            int lineCommentStart = whitespace.indexOf(LINE_COMMENT_START, pos);
            if (commentStart < 0) break;
            if (lineCommentStart >= 0 && lineCommentStart < commentStart) {
                pos = ConfigClassBuilder.findLineCommentEnd(whitespace, lineCommentStart) + 1;
                continue;
            }
            int endPos = ConfigClassBuilder.findCommentEndPos(whitespace, commentStart);
            if (whitespace.substring(commentStart).startsWith(ASDOC_COMMENT_START)) {
                String comment = whitespace.substring(commentStart + ASDOC_COMMENT_START.length(), endPos);
                lastAsDocComment = ConfigClassBuilder.parseAsDocComment(comment);
            }
            pos = endPos + COMMENT_END.length();
        }
        return lastAsDocComment;
    }

    public static int findCommentEndPos(String whitespace, int commentStart) {
        int endPos = whitespace.indexOf(COMMENT_END, commentStart + COMMENT_START.length());
        if (endPos < 0) {
            throw new IllegalStateException("unterminated comment found; this should be detected by the lexer");
        }
        return endPos;
    }

    public static int findLineCommentEnd(String whitespace, int lineCommentStart) {
        int endPos;
        int returnPos = whitespace.indexOf(13, lineCommentStart);
        int lineFeedPos = whitespace.indexOf(10, lineCommentStart);
        int n = returnPos < 0 ? lineFeedPos : (endPos = lineFeedPos < 0 ? returnPos : Math.min(returnPos, lineFeedPos));
        if (endPos < 0) {
            throw new IllegalStateException("unterminated line comment found; this should be detected by the lexer");
        }
        return endPos;
    }

    public static String parseAsDocComment(String comment) {
        String lastAsDocComment = comment.replaceAll("\\s*[\\r\\n]\\s*\\*[ \\t\u000b\\f]*", " ");
        lastAsDocComment = lastAsDocComment.replaceAll("\\s+", " ");
        lastAsDocComment = lastAsDocComment.trim();
        return lastAsDocComment;
    }

    private class ClassBodyVisitor
    extends AstVisitorBase {
        private ClassBodyVisitor() {
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
            if (functionDeclaration.isConstructor()) {
                String qualifiedParamTypeName;
                Type configType;
                IdeDeclaration paramType;
                TypeRelation optTypeRelation;
                Parameter firstParam;
                Parameters params = functionDeclaration.getParams();
                if (params != null && "config".equals((firstParam = (Parameter)params.getHead()).getName()) && (optTypeRelation = firstParam.getOptTypeRelation()) != null && (paramType = (configType = optTypeRelation.getType()).getIde().resolveDeclaration()) != null && !"Object".equals(qualifiedParamTypeName = paramType.getQualifiedNameStr())) {
                    ConfigClassBuilder.this.configClassName = qualifiedParamTypeName;
                }
                return;
            }
            if (functionDeclaration.isGetter() && !functionDeclaration.isStatic()) {
                String name = functionDeclaration.getName();
                String type = this.parseTypeDeclaration(functionDeclaration);
                String description = ConfigClassBuilder.parseDescription(functionDeclaration.getSymbol(), functionDeclaration.getSymModifiers());
                ConfigClassBuilder.this.configClass.addCfg(new ConfigAttribute(name, type, description));
            }
        }

        private String parseTypeDeclaration(FunctionDeclaration functionDeclaration) {
            TypeRelation optTypeRelation = functionDeclaration.getFun().getOptTypeRelation();
            String type = optTypeRelation != null ? optTypeRelation.getType().getSymbol().getText() : AS3Type.ANY.toString();
            return type;
        }
    }

    private class ClassAnnotationsVisitor
    extends AstVisitorBase {
        private ClassAnnotationsVisitor() {
        }

        @Override
        public void visitAnnotation(Annotation annotation) throws IOException {
            this.detectAsDoc(annotation);
            this.detectExtConfigAnnotation(annotation);
        }

        private void detectAsDoc(Annotation annotation) {
            if (ConfigClassBuilder.this.configClass.getDescription() == null) {
                String description = ConfigClassBuilder.parseDescription(annotation.getLeftBracket(), new JooSymbol[0]);
                ConfigClassBuilder.this.configClass.setDescription(description);
            }
        }

        private void detectExtConfigAnnotation(Annotation annotation) {
            if (ConfigClassBuilder.EXT_CONFIG_META_NAME.equals(annotation.getMetaName())) {
                if (ConfigClassBuilder.this.configClass.getComponentClassName() != null) {
                    throw new CompilerError(annotation.getSymbol(), "Only one [ExtConfig] annotation may be given.");
                }
                for (CommaSeparatedList<AnnotationParameter> annotationParameters = annotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                    AnnotationParameter annotationParameter = annotationParameters.getHead();
                    Ide optNameIde = annotationParameter.getOptName();
                    if (optNameIde == null) continue;
                    String parameterName = optNameIde.getName();
                    LiteralExpr annotationParameterValue = annotationParameter.getValue();
                    String parameterValue = null;
                    if (annotationParameterValue != null) {
                        JooSymbol symbol2 = annotationParameterValue.getSymbol();
                        if (symbol2.sym != 98) {
                            throw new CompilerError(symbol2, "The " + parameterName + " parameter of an [" + ConfigClassBuilder.EXT_CONFIG_META_NAME + "] annotation must be a string literal.");
                        }
                        parameterValue = (String)symbol2.getJooValue();
                    }
                    if (ConfigClassBuilder.TARGET_ANNOTATION_PARAMETER_NAME.equals(parameterName)) {
                        if (parameterValue == null) {
                            throw new CompilerError(optNameIde.getSymbol(), "The " + parameterName + " parameter of an [" + ConfigClassBuilder.EXT_CONFIG_META_NAME + "] annotation must have a value.");
                        }
                        ConfigClassBuilder.this.configClass.setComponentClassName(parameterValue);
                        continue;
                    }
                    try {
                        ConfigClassBuilder.this.configClass.setType(ConfigClassType.fromExtConfigAttribute(parameterName));
                    }
                    catch (IllegalArgumentException e) {
                        throw new CompilerError(optNameIde.getSymbol(), "'" + parameterName + "' is not a valid parameter of an [" + ConfigClassBuilder.EXT_CONFIG_META_NAME + "] annotation (only 'xtype', 'ptype', 'type', 'gctype' are allowed).", e);
                    }
                    ConfigClassBuilder.this.configClass.setTypeValue(parameterValue);
                }
                if (ConfigClassBuilder.this.configClass.getComponentClassName() == null) {
                    throw new CompilerError(annotation.getSymbol(), "A target parameter must be provided for an [ExtConfig] annotation.");
                }
            }
        }
    }
}

